/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;

public class SrcVieAgainRegionValueValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData context) {
        DynamicObject billObj = context.getBillObj();
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return;
        }
        String viePattern = null;
        String taxType = null;
        try {
            viePattern = billObj.getString("project.viepattern");
            taxType = billObj.getString("project.taxtype");
        }
        catch (Exception e) {
            viePattern = "1";
            taxType = "2";
        }
        Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)taxType);
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : rows) {
            if (row.getBigDecimal("viefrom").compareTo(BigDecimal.ZERO) <= 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c, %2$s \u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SrcVieAgainRegionValueValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), i, viePatternTitleMap.get("viefrom")));
            }
            if (row.getBigDecimal("vieto").compareTo(BigDecimal.ZERO) <= 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c1$s\u884c, %2$s \u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SrcVieAgainRegionValueValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), i, viePatternTitleMap.get("vieto")));
            }
            ++i;
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            context.setSucced(false);
            context.setMessage(sb.toString());
        }
    }
}

