/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcVieOpendateValidator
implements ISrcValidator {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void validate(SrcValidatorData arg0) {
        List compKeys = TemplateUtil.getCompKeyList((DynamicObject)arg0.getBillObj());
        if (!compKeys.contains("src_vie_rule")) {
            return;
        }
        QFilter qfilter = new QFilter("id", "=", arg0.getBillObj().getPkValue());
        DynamicObject ruleObj = QueryServiceHelper.queryOne((String)"src_vie_rule", (String)"planopendate", (QFilter[])qfilter.toArray());
        if (ruleObj == null) {
            return;
        }
        Date vieOpenDate = ruleObj.getDate("planopendate");
        if (vieOpenDate == null) {
            return;
        }
        DynamicObject baseObj = QueryServiceHelper.queryOne((String)"src_project_base", (String)"stopbiddate,replydate", (QFilter[])qfilter.toArray());
        if (baseObj == null) {
            return;
        }
        Date replyDate = baseObj.getDate("replydate");
        Date stopBidDate = baseObj.getDate("stopbiddate");
        StringBuilder message = new StringBuilder();
        if (replyDate != null && !vieOpenDate.after(replyDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcVieOpendateValidator_2", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(replyDate), sdf.format(vieOpenDate)));
        }
        if (stopBidDate != null && !vieOpenDate.after(stopBidDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcVieOpendateValidator_3", (String)"scm-src-opplugin", (Object[])new Object[0]), sdf.format(stopBidDate), sdf.format(vieOpenDate)));
        }
        if (message.length() > 0) {
            arg0.setSucced(false);
            arg0.setMessage(message.toString());
        }
    }
}

