/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.afterhandle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenAfterHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcAutoMaterialEndHandler
implements ISrcBidOpenAfterHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext args) {
        ExtPluginContext context = this.createChangeContext(args);
        if (!this.isNeedChange(context)) {
            return;
        }
        this.initValueMap(context);
        DynamicObject changeObj = SrcBidChangeUtil.getBidChangeBill(context);
        if (null == changeObj) {
            changeObj = SrcBidChangeUtil.createBidChangeBill(context);
        }
        PdsCommonUtils.doOperation((DynamicObject)changeObj, (String)"submit");
        PdsCommonUtils.doOperation((DynamicObject)changeObj, (String)"audit");
    }

    public ExtPluginContext createChangeContext(SrcBidOpenContext args) {
        ExtPluginContext context = new ExtPluginContext();
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)args.getProjectId(), (String)"src_project");
        context.setProjectObj(projectObj);
        context.setProjectId(args.getProjectId());
        return context;
    }

    public boolean isNeedChange(ExtPluginContext context) {
        boolean isValid;
        long schemeId = SchemeFilterUtils.getFirstSchemeId((DynamicObject)context.getProjectObj(), (String)"src_materialend_scheme", null);
        if (schemeId == 0L) {
            return false;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"pds_extfilter");
        String number = schemeObj.getString("number");
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("number", number);
        List purlistIds = SchemeFilterUtils.getAllSchemeIds((DynamicObject)context.getProjectObj(), (String)number, paramMap);
        if (null == purlistIds || purlistIds.size() == 0) {
            return false;
        }
        Set endPurlisIds = PdsPurlistUtils.getPurilstEndIds((long)context.getProjectId());
        purlistIds.removeAll(endPurlisIds);
        Set validPurlisIds = PdsPurlistUtils.getValidPurilstIds((long)context.getProjectId(), (Set)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.TOQUOTE.getValue(), ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()}));
        boolean bl = isValid = PdsCommonUtils.getIntersectSet(new HashSet(purlistIds), (Set)validPurlisIds).size() > 0;
        if (null == purlistIds || purlistIds.size() == 0 || !isValid) {
            return false;
        }
        context.setBillId(schemeId);
        context.getParamMap().put("number", number);
        context.getParamMap().put("purlist", purlistIds);
        return true;
    }

    public void initValueMap(ExtPluginContext context) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
        valueMap.put("changesource", "3");
        valueMap.put("project", context.getProjectId());
        long templateId = PdsCommonUtils.getBasedataIdByNumber((String)"pds_tplconfig", (String)"SYS080");
        valueMap.put("template", templateId);
        DynamicObject changeType = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"pds_tplconfig");
        context.setSourceObj(changeType);
        valueMap.put("remark", ResManager.loadKDString((String)"\u5f00\u6807\u540e\u62a5\u4ef7\u4f9b\u5e94\u5546\u6570\u4e0d\u7b26\u5408\u8981\u6c42\u7684\u6807\u7684\u81ea\u52a8\u8fdb\u884c\u6d41\u6807\u3002", (String)"SrcAutoMaterialEndHandler_0", (String)"scm-src-common", (Object[])new Object[0]));
        valueMap.put("biztype", context.getProjectObj().getLong("biztype.id"));
        valueMap.put("org", context.getProjectObj().getLong("org.id"));
        valueMap.put("currentnode", PdsCommonUtils.getNodeIdByEntityName((String)context.getProjectObj().getDataEntityType().getName()));
        context.getParamMap2().put("src_bidchange", valueMap);
    }
}

