/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.afterhandle;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsObjectCacheUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenAfterHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcProjectStatusHandler
implements ISrcBidOpenAfterHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.setBidOpenStatus(context);
    }

    protected void setBidOpenStatus(SrcBidOpenContext context) {
        DynamicObject openObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_bidopen_open");
        if (null == openObj) {
            return;
        }
        String openStatus = null;
        if (null == openStatus) {
            openStatus = this.getArchiveStatus(context);
        }
        if (null == openStatus) {
            openStatus = this.getTeminalStatus(context);
        }
        if (null == openStatus) {
            openStatus = this.getDecisionStatus(context);
        }
        if (null == openStatus) {
            openStatus = this.getNegotiateStatus(context);
        }
        if (null == openStatus) {
            openStatus = this.getPackageOpenStatus(context, openObj);
        }
        if (null == openStatus) {
            openStatus = this.getOfflineOpenStatus(context);
        }
        if (null == openStatus) {
            openStatus = this.getOpenStatusBySourceType(context);
        }
        this.saveOpenStatus(context, openObj, openStatus);
        PdsObjectCacheUtils.setProjectParam((long)context.getProjectId(), (String)"openstatus", (String)openStatus);
    }

    private String getArchiveStatus(SrcBidOpenContext context) {
        QFilter archivefilters = new QFilter("id", "=", (Object)context.getProjectId());
        archivefilters.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (QueryServiceHelper.exists((String)"src_placeonfile", (QFilter[])archivefilters.toArray())) {
            return BidOpenStatusEnums.ARCHIVED.getValue();
        }
        return null;
    }

    private String getTeminalStatus(SrcBidOpenContext context) {
        QFilter teminalfilters = new QFilter("id", "=", (Object)context.getProjectId());
        teminalfilters.and(new QFilter("bizstatus", "=", (Object)ProcessStatusEnums.CLOSED.getValue()).or("bizstatus", "=", (Object)ProcessStatusEnums.TERMINATED.getValue()));
        if (QueryServiceHelper.exists((String)"src_project", (QFilter[])teminalfilters.toArray())) {
            return BidOpenStatusEnums.TERMINATED.getValue();
        }
        return null;
    }

    private String getDecisionStatus(SrcBidOpenContext context) {
        QFilter decfilters = new QFilter("id", "=", (Object)context.getProjectId());
        decfilters.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (QueryServiceHelper.exists((String)"src_decision", (QFilter[])decfilters.toArray())) {
            return BidOpenStatusEnums.DECISION.getValue();
        }
        return null;
    }

    private String getNegotiateStatus(SrcBidOpenContext context) {
        QFilter negfilters = new QFilter("project", "=", (Object)context.getProjectId());
        negfilters.and("isquotebidopen", "=", (Object)"0");
        if (QueryServiceHelper.exists((String)"src_negotiatebill", (QFilter[])negfilters.toArray())) {
            return BidOpenStatusEnums.NEGOTIATE.getValue();
        }
        return null;
    }

    private String getPackageOpenStatus(SrcBidOpenContext context, DynamicObject openObj) {
        DynamicObjectCollection rows = openObj.getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return null;
        }
        String openType = openObj.getString("opentype");
        if ("1".equals(openType) || "9".equals(openType)) {
            if (rows.stream().anyMatch(e -> e.getBoolean("istecopen") || e.getBoolean("isbizopen"))) {
                return BidOpenStatusEnums.OPEN.getValue();
            }
        } else if ("4".equals(openType)) {
            boolean isTecOpen = false;
            boolean isBizOpen = false;
            if (rows.stream().anyMatch(e -> e.getBoolean("istecopen"))) {
                isTecOpen = true;
            }
            if (rows.stream().anyMatch(e -> e.getBoolean("isbizopen"))) {
                isBizOpen = true;
            }
            if (isTecOpen && isBizOpen) {
                return BidOpenStatusEnums.OPEN.getValue();
            }
            if (isTecOpen) {
                return BidOpenStatusEnums.TECOPEN.getValue();
            }
            if (isBizOpen) {
                return BidOpenStatusEnums.BIZOPEN.getValue();
            }
        } else {
            if (rows.stream().anyMatch(e -> e.getBoolean("isbizopen"))) {
                return BidOpenStatusEnums.OPEN.getValue();
            }
            if (rows.stream().anyMatch(e -> e.getBoolean("istecopen"))) {
                return BidOpenStatusEnums.TECOPEN.getValue();
            }
        }
        return null;
    }

    private String getOfflineOpenStatus(SrcBidOpenContext context) {
        QFilter purlistfilters = new QFilter("project", "=", (Object)context.getProjectId());
        purlistfilters.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        if (QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])purlistfilters.toArray())) {
            return BidOpenStatusEnums.OPEN.getValue();
        }
        return null;
    }

    private String getOpenStatusBySourceType(SrcBidOpenContext context) {
        String sourceType = context.getBillObj().getString("sourcetype.number");
        if (Objects.isNull(sourceType)) {
            sourceType = "";
        }
        if (sourceType.equals(SourceTypeEnums.INPUT_PRICE.getValue())) {
            return BidOpenStatusEnums.DECISION.getValue();
        }
        if (sourceType.equals(SourceTypeEnums.DIRECT_PUR.getValue()) || sourceType.equals(SourceTypeEnums.NET_PUR.getValue()) || sourceType.equals(SourceTypeEnums.INTERNAL_SALE.getValue())) {
            return BidOpenStatusEnums.OPEN.getValue();
        }
        return BidOpenStatusEnums.NOOPEN.getValue();
    }

    private void saveOpenStatus(SrcBidOpenContext context, DynamicObject openObj, String openStatus) {
        if (null == openObj || null == openStatus) {
            return;
        }
        openObj.set("openstatus", (Object)openStatus);
        Map resultMap = SrmCommonUtil.saveDynamicObject((String)"src_bidopen_open", (DynamicObject[])new DynamicObject[]{openObj});
        context.setResultMap(resultMap);
    }
}

