/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.afterhandle;

import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenAfterHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcSendMessageHandler
implements ISrcBidOpenAfterHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.sendMessage(context);
    }

    public void sendMessage(SrcBidOpenContext context) {
        String eventKey = this.getEventKey(context);
        if (null == eventKey) {
            return;
        }
        long billId = PdsCommonUtils.object2Long((Object)context.getBillObj().getPkValue());
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)eventKey, (String)"pds_sendmessage", (Object[])new Long[]{billId}, (OperateOption)option);
    }

    public String getEventKey(SrcBidOpenContext context) {
        String operation = context.getOperateKey();
        if (Objects.equals(operation, "allopen") || Objects.equals(operation, "pushscore")) {
            return "scoretasksendmsgallopen";
        }
        if ("tecopen".equals(operation)) {
            return "scoretasksendmsgtecopen";
        }
        if ("bizopen".equals(operation)) {
            return "scoretasksendmsgbizopen";
        }
        return null;
    }
}

