/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.handle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidDocTypeEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;

public class SrcBiddocOpenHandler
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.openBidDoc(context);
    }

    protected void openBidDoc(SrcBidOpenContext context) {
        List<String> docTypeList = null;
        QFilter docTypeFilter = null;
        QFilter bidDocFilter = null;
        switch (context.getOpenType()) {
            case "allopen": {
                Map fileTypeNameMap = ComboEditUtils.getComboKeyValueMapFromEntry((String)"src_biddoc_tnd", (String)"entryentity", (String)"packfiletype");
                docTypeList = fileTypeNameMap.keySet().stream().collect(Collectors.toList());
                docTypeFilter = new QFilter("packfiletype", "in", docTypeList);
                bidDocFilter = context.getTecFilter().copy().and(docTypeFilter);
                break;
            }
            case "tecopen": {
                docTypeList = Arrays.asList(BidDocTypeEnums.TEC_DOC.getValue(), BidDocTypeEnums.OTH_DOC.getValue(), BidDocTypeEnums.COM_DOC.getValue(), BidDocTypeEnums.APT_DOC.getValue());
                docTypeFilter = new QFilter("packfiletype", "in", docTypeList);
                bidDocFilter = context.getTecFilter().copy().and(docTypeFilter);
                break;
            }
            case "bizopen": {
                docTypeList = Arrays.asList(BidDocTypeEnums.BIZ_DOC.getValue(), BidDocTypeEnums.APT_DOC.getValue());
                docTypeFilter = new QFilter("packfiletype", "in", docTypeList);
                bidDocFilter = context.getBizFilter().copy().and(docTypeFilter);
                break;
            }
            case "aptopen": {
                docTypeList = Collections.singletonList(BidDocTypeEnums.APT_DOC.getValue());
                docTypeFilter = new QFilter("packfiletype", "in", docTypeList);
                bidDocFilter = context.getAptFilter().copy().and(docTypeFilter);
                break;
            }
            default: {
                return;
            }
        }
        context.setBidDocFilter(bidDocFilter);
        this.setBidDocStatus(context);
    }

    private void setBidDocStatus(SrcBidOpenContext context) {
        DynamicObject[] bidDocObjs = BusinessDataServiceHelper.load((String)"src_biddoctplf7", (String)"project,entrystatus", (QFilter[])context.getBidDocFilter().toArray());
        if (null == bidDocObjs || bidDocObjs.length == 0) {
            return;
        }
        for (DynamicObject bidDocObj : bidDocObjs) {
            bidDocObj.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
        }
        Map resultMap = SrmCommonUtil.saveDynamicObject((String)"src_biddoctplf7", (DynamicObject[])bidDocObjs);
        context.setResultMap(resultMap);
    }
}

