/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bidopen.handle;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.bidopen.ISrcBidOpenHandler;
import kd.scm.src.common.bidopen.SrcBidOpenContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;

public class SrcPackageAptStatusHandler
implements ISrcBidOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcBidOpenContext context) {
        this.setPackageOpenStatus(context);
    }

    protected void setPackageOpenStatus(SrcBidOpenContext context) {
        String bidopenpackage = SrcBidOpenFacade.getBidOpenNameMap(context.getBillObj()).get("src_bidopenpackage");
        String selectFields = DynamicObjectUtil.getSelectfields((String)bidopenpackage, (boolean)false);
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)bidopenpackage, (String)selectFields, (QFilter[])context.getPackageFilter().toArray());
        HashSet<Long> packageIds = new HashSet<Long>(packageObjs.length);
        for (DynamicObject packageObj : packageObjs) {
            SrcBidOpenFacade.updateAptOpenStatus(packageObj);
            if (!bidopenpackage.equals("src_supplieropen")) continue;
            packageIds.add(packageObj.getLong("package.id"));
        }
        Map resultMap = SrmCommonUtil.saveDynamicObject((String)bidopenpackage, (DynamicObject[])packageObjs);
        context.setResultMap(resultMap);
        if (packageIds.size() > 0) {
            long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getView().getModel().getDataEntity());
            SrcBidOpenFacade.updatePackageOpenStatus(projectId, packageIds, "isaptopen");
        }
    }
}

