/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.bizquery;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public interface ISrcReferPriceHandler
extends IExtPluginHandler {
    default public QFilter getHistoryPurlistFilter(Set<Long> materialIds, long currencyId, int monthnum) {
        Date historyDate = SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)(-monthnum * 30));
        QFilter qfilters = new QFilter("material", "in", materialIds);
        qfilters.and("loccurr", "=", (Object)currencyId);
        qfilters.and("billid.createtime", ">=", (Object)historyDate);
        qfilters.and("material", ">", (Object)0L);
        qfilters.and(new QFilter("locprice", ">", (Object)BigDecimal.ZERO).or("loctaxprice", ">", (Object)BigDecimal.ZERO));
        return qfilters;
    }

    default public Map<Long, DynamicObject> getHistoryPurlistRows(QFilter qfilters, String orderType, String rankType) {
        String selectFields = "material.id,category.id,locprice,loctaxprice";
        String orderby = " material";
        orderby = "optimalprice".equals(orderType) ? ("2".equals(rankType) ? orderby + ", locprice desc, loctaxprice desc" : orderby + ", locprice, loctaxprice") : orderby + ", billid.createtime desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_contractentry", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("material.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    default public void setOptimalPrice(Map<Long, List<DynamicObject>> purlistMap, List<DynamicObject> purlistList, Map<Long, DynamicObject> optimalPurlistMap, String price, String taxprice) {
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject optimalPurlist = optimalPurlistMap.get(entry.getKey());
            if (null == optimalPurlist) continue;
            for (DynamicObject row : entry.getValue()) {
                row.set(price, (Object)optimalPurlist.getBigDecimal("locprice"));
                row.set(taxprice, (Object)optimalPurlist.getBigDecimal("loctaxprice"));
            }
            purlistList.addAll((Collection<DynamicObject>)entry.getValue());
        }
    }

    default public void setPurOrderPrice(Map<String, List<DynamicObject>> purlistMap, Map<String, DynamicObject> purOrderMap, String price, String taxprice) {
        for (Map.Entry<String, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject purOrderObj = purOrderMap.get(entry.getKey());
            if (null == purOrderObj) continue;
            for (DynamicObject row : entry.getValue()) {
                row.set(price, (Object)purOrderObj.getBigDecimal("materialentry.price"));
                row.set(taxprice, (Object)purOrderObj.getBigDecimal("materialentry.taxprice"));
            }
        }
    }

    default public QFilter getPurOrderFilter(Set<Long> materialIds, Set<Long> unitIds, Set<Long> currencyIds, int monthnum) {
        Date historyDate = SrcDateUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)(-monthnum * 30));
        QFilter qfilters = new QFilter("billstatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()}));
        qfilters.and("billdate", ">=", (Object)historyDate);
        qfilters.and("materialentry.material", "in", materialIds);
        qfilters.and("materialentry.unit", "in", unitIds);
        qfilters.and("curr", "in", currencyIds);
        qfilters.and(new QFilter("materialentry.price", ">", (Object)BigDecimal.ZERO).or("materialentry.taxprice", ">", (Object)BigDecimal.ZERO));
        return qfilters;
    }

    default public Map<String, DynamicObject> getPurOrderRows(QFilter qfilters) {
        String selectFields = "billdate,curr.id,materialentry.material.id,materialentry.unit.id,materialentry.price,materialentry.taxprice";
        String orderby = " materialentry.material, materialentry.unit,curr.id, billdate desc, auditdate desc";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"pur_order", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("materialentry.material.id") + '_' + e.getString("materialentry.unit.id") + '_' + e.getString("curr.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    default public long getCurrencyId(ExtPluginContext context) {
        return PdsCommonUtils.object2Long(context.getParamMap().get("currency"));
    }

    default public String getMaterialIdField(ExtPluginContext context) {
        return PdsCommonUtils.object2String(context.getParamMap().get("fieldnamematerial"), (String)"material.id");
    }

    default public String getUnitIdField(ExtPluginContext context) {
        return PdsCommonUtils.object2String(context.getParamMap().get("fieldnameunit"), (String)"unit.id");
    }

    default public String getCurrencyIdField(ExtPluginContext context) {
        return PdsCommonUtils.object2String(context.getParamMap().get("fieldnamecurrency"), (String)"currency.id");
    }
}

