/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import java.io.Serializable;
import java.util.List;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcGlobalCalcContext;

public interface ISrcCalcFacade
extends Serializable {
    public void calculate(String var1, long var2, SrcGlobalCalcContext var4, boolean var5);

    default public void initContext(SrcCalcContext context, String pluginNumber) {
        List<ISrcCalculate> srcInits = this.getSrcInits(pluginNumber);
        for (ISrcCalculate srcInit : srcInits) {
            srcInit.process(context);
        }
    }

    default public void prepareData(SrcCalcContext context, String pluginNumber) {
        List<ISrcCalculate> srcPrepares = this.getSrcPrepares(pluginNumber);
        for (ISrcCalculate srcPrepare : srcPrepares) {
            srcPrepare.process(context);
        }
    }

    default public void handleData(SrcCalcContext context, String pluginNumber) {
        List<ISrcCalculate> srcProcesss = this.getSrcProcesss(pluginNumber);
        for (ISrcCalculate srcProcess : srcProcesss) {
            srcProcess.process(context);
        }
    }

    default public void handleResult(SrcCalcContext context, String pluginNumber) {
        List<ISrcCalculate> srcResults = this.getSrcResults(pluginNumber);
        for (ISrcCalculate srcResult : srcResults) {
            srcResult.process(context);
        }
    }

    default public List<ISrcCalculate> getSrcInits(String pluginNumber) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(pluginNumber, null);
    }

    default public List<ISrcCalculate> getSrcPrepares(String pluginNumber) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(pluginNumber, null);
    }

    default public List<ISrcCalculate> getSrcProcesss(String pluginNumber) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(pluginNumber, null);
    }

    default public List<ISrcCalculate> getSrcResults(String pluginNumber) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(pluginNumber, null);
    }
}

