/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;

public class SrcCalcHandleTmpSup
implements ISrcCalculate {
    @Override
    public void process(SrcCalcContext context) {
        if (context.getGlobalContext().isHandleTmpSup()) {
            return;
        }
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getBillId()).and("supplier.id", "=", (Object)0L).and("suppliername", "!=", (Object)"");
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"suppliertype,supplier,suppliername", (QFilter[])new QFilter[]{qFilter});
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        boolean haveChange = false;
        for (DynamicObject purlistObj : purlistObjs) {
            long supplierId = purlistObj.getLong("supplier.id");
            String supplierName = purlistObj.getString("suppliername");
            if (supplierId != 0L || supplierName == null || supplierName.trim().length() <= 0) continue;
            supplierId = SrcCalcHelper.getTmpSupplierId(supplierName);
            purlistObj.set("suppliertype", (Object)"src_supplier_tmp");
            purlistObj.set("supplier_id", (Object)supplierId);
            haveChange = true;
        }
        if (haveChange) {
            SaveServiceHelper.save((DynamicObject[])purlistObjs);
        }
        context.getGlobalContext().setHandleTmpSup(Boolean.TRUE);
    }
}

