/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.enums.SourceTypeEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;
import kd.scm.src.common.calc.rank.SrcRankFacade;

public class SrcRankCalcFinalScore
implements ISrcRankCoreCalc {
    private static final long serialVersionUID = 1L;
    private String info = ResManager.loadKDString((String)"\u5546\u52a1\u4ef7\u683c\u6216\u57fa\u51c6\u4ef7\u4e3a0\uff0c\u6ca1\u6709\u8c03\u7528\u8ba1\u7b97\u5546\u52a1\u5f97\u5206\u7684\u6838\u5fc3\u7b97\u6cd5\u3002", (String)"SrcRankCalcFinalScore_0", (String)"scm-src-common", (Object[])new Object[0]);

    @Override
    public void process(SrcCalcContext context) {
        this.calcFinalScore(context);
    }

    protected void calcFinalScore(SrcCalcContext context) {
        ArrayList<DynamicObject> assessList = new ArrayList<DynamicObject>(32);
        ArrayList<DynamicObject> manualScoreList = new ArrayList<DynamicObject>(32);
        Map<String, Object> groupIdMap = SrcCalcHelper.getRankObjectIdFromKey(context.getSumType(), context.getCurrGKey());
        long groupPackageId = PdsCommonUtils.object2Long((Object)groupIdMap.get("packageid"));
        long groupPurlistId = PdsCommonUtils.object2Long((Object)groupIdMap.get("purlistid"));
        Map baseValueMap = null;
        if (SrcBidOpenUtils.isManualBidBaseValue(context.getProjectObj(), context.getSchemeObj())) {
            String key = String.valueOf(PdsCommonUtils.object2Long((Object)context.getProjectObj().getPkValue())) + '_' + "src_bidassess_bizsum" + '_' + "basevalue";
            baseValueMap = (Map)PdsObjectPools.getInstance((String)key);
        }
        for (String currRankKey : context.getRankValueMap().keySet()) {
            long purlistId;
            Map<String, Object> idMap = SrcCalcHelper.getRankObjectIdFromKey(context.getSumType(), currRankKey);
            long supplierId = PdsCommonUtils.object2Long((Object)idMap.get("supplierid"));
            long packageId = PdsCommonUtils.object2Long((Object)idMap.get("packageid"));
            long purlistId0 = purlistId = PdsCommonUtils.object2Long((Object)idMap.get("purlistid"));
            if (context.getSumType().equals("2")) {
                if (packageId != groupPackageId) {
                    continue;
                }
            } else if (context.getSumType().equals("3")) {
                if (packageId != groupPackageId || purlistId != groupPurlistId) continue;
                String[] splitKey = ((String)idMap.get("supplierid")).split("\\_");
                supplierId = PdsCommonUtils.object2Long((Object)splitKey[0]);
                long entryId = PdsCommonUtils.object2Long((Object)splitKey[1]);
                context.getEntryid_PurlistidMap().put(entryId, purlistId);
                purlistId = entryId;
            }
            context.setCurrBizAmount(context.getRankValueMap().get(currRankKey));
            context.setCurrBizScore(BigDecimal.ZERO);
            boolean isAllPresent = PdsCommonUtils.object2Boolean((Object)context.getCustomMap().get("ispresent"));
            if (!context.getSumType().equals("3") || !context.getPresentSet().contains(purlistId) || isAllPresent) {
                this.calcBizScore(context, baseValueMap, supplierId, packageId, purlistId, purlistId0);
            }
            this.createManualScore(context, manualScoreList, supplierId, packageId, purlistId);
            this.createSystemScore(context, assessList, supplierId, packageId, purlistId, purlistId0);
        }
        context.setAssessList(assessList);
        context.setManualScoreList(manualScoreList);
    }

    protected void createManualScore(SrcCalcContext context, List<DynamicObject> manualScoreList, long supplierId, long packageId, long purlistId) {
        QFilter bizScorefilters;
        DynamicObject bizScoreobj;
        if (!context.isManualScore()) {
            return;
        }
        if (context.getTenderSupplierSet().size() > 0) {
            String pkg_supKey = null;
            pkg_supKey = "2".equals(context.getManageType()) && "2".equals(context.getSumType()) ? String.valueOf(packageId) + '_' + String.valueOf(supplierId) : String.valueOf(String.valueOf(supplierId));
            if (!context.getTenderSupplierSet().contains(pkg_supKey)) {
                return;
            }
        }
        if ((bizScoreobj = QueryServiceHelper.queryOne((String)"src_manualscore_meta", (String)"id", (QFilter[])(bizScorefilters = new QFilter("billid", "=", (Object)context.getBillId()).and("supplier_id", "=", (Object)supplierId).and("package_id", "=", (Object)packageId).and("purlist_id", "=", (Object)purlistId)).toArray())) != null) {
            bizScoreobj = BusinessDataServiceHelper.loadSingle((Object)bizScoreobj.getLong("id"), (String)"src_manualscore_meta");
            context.setCurrBizScore(bizScoreobj.getBigDecimal("bizscore"));
        } else {
            bizScoreobj = BusinessDataServiceHelper.newDynamicObject((String)"src_manualscore_meta");
            bizScoreobj.set("billid", (Object)context.getBillId());
            bizScoreobj.set("parentid", (Object)context.getBillId());
            bizScoreobj.set("fseq", (Object)context.getIndex());
            bizScoreobj.set("supplier_id", (Object)supplierId);
            bizScoreobj.set("suppliertype", (Object)context.getSupTypeMap().get(String.valueOf(supplierId)));
            bizScoreobj.set("package_id", (Object)packageId);
            bizScoreobj.set("purlist_id", (Object)purlistId);
            bizScoreobj.set("bizscore", (Object)context.getCurrBizScore());
        }
        bizScoreobj.set("bizamount", (Object)context.getCurrBizAmount().setScale(6, 4));
        manualScoreList.add(bizScoreobj);
    }

    protected void createSystemScore(SrcCalcContext context, List<DynamicObject> assessList, long supplierId, long packageId, long purlistId, long purlistId0) {
        BigDecimal bizScore;
        BigDecimal autoBizScore = bizScore = this.getFinalBizScore(context, context.getCurrBizScore());
        DynamicObject entryObj = BusinessDataServiceHelper.newDynamicObject((String)"src_bidassess_biz");
        entryObj.set("billid", (Object)context.getBillId());
        entryObj.set("parentid", (Object)context.getBillId());
        entryObj.set("fseq", (Object)context.getIndex());
        entryObj.set("supplier_id", (Object)supplierId);
        entryObj.set("suppliertype", (Object)context.getSupTypeMap().get(String.valueOf(supplierId)));
        entryObj.set("pkggroup", (Object)context.getPkgGroupId());
        entryObj.set("package_id", (Object)packageId);
        entryObj.set("purlist_id", (Object)purlistId);
        entryObj.set("purlistid0", (Object)purlistId0);
        entryObj.set("bizamount", (Object)context.getCurrBizAmount().setScale(6, 4));
        entryObj.set("minvalue", (Object)context.getMinValue().setScale(6, 4));
        entryObj.set("maxvalue", (Object)context.getMaxValue().setScale(6, 4));
        entryObj.set("avgvalue", (Object)context.getAvgValue().setScale(6, 4));
        BigDecimal currBaseAmount = context.getCurrBaseAmount();
        if (Objects.nonNull(currBaseAmount)) {
            entryObj.set("basevalue", (Object)currBaseAmount.setScale(6, 4));
        }
        entryObj.set("bizscore", (Object)bizScore);
        context.setSupplierId(supplierId);
        context.setPackageId(packageId);
        context.setPurlistId(purlistId);
        Map<String, BigDecimal> scoreMap = SrcCalcHelper.getTecAndBizAndOthScore(context);
        BigDecimal tecScore = scoreMap.get("tecscore");
        BigDecimal othScore = scoreMap.get("othscore");
        entryObj.set("tecscore", (Object)tecScore.setScale(6, 4));
        entryObj.set("othscore", (Object)othScore.setScale(6, 4));
        BigDecimal weightScore = BigDecimal.ZERO;
        if (context.getScoretype().equals("2") && !context.isManualScore()) {
            tecScore = scoreMap.get("tecscore");
            bizScore = scoreMap.get("bizscore");
            othScore = scoreMap.get("othscore");
            entryObj.set("tecscore", (Object)tecScore.setScale(6, 4));
            entryObj.set("bizscore", (Object)bizScore.setScale(6, 4));
            entryObj.set("othscore", (Object)othScore.setScale(6, 4));
            weightScore = tecScore.add(bizScore).add(othScore);
            if (weightScore.compareTo(BigDecimal.ZERO) == 0) {
                if (null == context.getGlobalContext().getCustomMap().get("offline_noManualScore")) {
                    context.getGlobalContext().setMessage(ResManager.loadKDString((String)"\u7ebf\u4e0b\u8bc4\u5206\u6c47\u603b\u8868\u7684\u8bc4\u5206\u5168\u90e8\u4e3a0\u3002", (String)"SrcRankCalcFinalScore_1", (String)"scm-src-common", (Object[])new Object[0]));
                    context.getGlobalContext().getCustomMap().put("offline_noManualScore", "1");
                }
                entryObj.set("bizscore", (Object)autoBizScore.setScale(6, 4));
                weightScore = autoBizScore;
            }
        } else if (context.isBizScore()) {
            BigDecimal newBizScore = scoreMap.get("bizscore");
            entryObj.set("bizscore", (Object)newBizScore.setScale(6, 4));
            weightScore = tecScore.add(newBizScore).add(othScore);
        } else {
            weightScore = tecScore.add(bizScore).add(othScore);
        }
        entryObj.set("sumscore", (Object)weightScore.setScale(6, 4));
        this.reSetBizAssessScore(context, entryObj);
        assessList.add(entryObj);
        context.setIndex(context.getIndex() + 1);
    }

    private void reSetBizAssessScore(SrcCalcContext context, DynamicObject entryObj) {
        if (context.getPreBidAssessMap() != null && context.getPreBidAssessMap().size() > 0) {
            String key = String.valueOf(context.getSupplierId()) + '_' + String.valueOf(context.getPackageId()) + '_' + String.valueOf(context.getPurlistId());
            DynamicObject preObj = context.getPreBidAssessMap().get(key);
            if (null != preObj) {
                entryObj.set("tecscore", (Object)preObj.getBigDecimal("tecscore"));
                entryObj.set("bizscore", (Object)preObj.getBigDecimal("bizscore"));
                entryObj.set("othscore", (Object)preObj.getBigDecimal("othscore"));
                entryObj.set("sumscore", (Object)preObj.getBigDecimal("sumscore"));
            }
        }
    }

    protected void calcBizScore(SrcCalcContext context, Map<String, DynamicObject> baseValueMap, long supplierId, long packageId, long purlistId, long purlistId0) {
        if (context.isBizScore()) {
            return;
        }
        BigDecimal baseAmount = BigDecimal.ZERO;
        switch (context.getRankCalcType()) {
            case "1": 
            case "4": {
                baseAmount = context.getMinValue();
                break;
            }
            case "2": {
                baseAmount = context.getMaxValue();
                break;
            }
            case "3": {
                baseAmount = context.getAvgValue();
                break;
            }
            case "5": {
                baseAmount = context.getBaseValue();
                break;
            }
            case "6": {
                baseAmount = SrcRankFacade.calcBidBaseScore(context, context.getAvgValue(), baseValueMap, supplierId, packageId, purlistId, purlistId0);
                break;
            }
        }
        context.setCurrBaseAmount(baseAmount);
        if (context.getCurrBizAmount().compareTo(BigDecimal.ZERO) <= 0) {
            long sourceTypeId = context.getProjectObj().getLong("sourcetype.id");
            Set sourceTypeSet = PdsCommonUtils.buildSet((Long[])new Long[]{SourceTypeEnums.SCHEME_AWARD.getId(), SourceTypeEnums.SCHEME_AWARD2.getId()});
            if (!sourceTypeSet.contains(sourceTypeId) && PdsCommonUtils.object2Boolean((Object)context.getCustomMap().get("ispresent"))) {
                context.setCurrBaseAmount(BigDecimal.ONE);
            }
        }
        if (context.getCurrBizAmount().compareTo(BigDecimal.ZERO) > 0 && context.getCurrBaseAmount().compareTo(BigDecimal.ZERO) > 0) {
            SrcRankFacade.autoCalcBizSscore(context);
        } else {
            if (null == context.getGlobalContext().getMessage() || null != this.info && !context.getGlobalContext().getMessage().toString().contains(this.info)) {
                context.getGlobalContext().getMessage().append(this.info);
            }
            context.setCurrBizScore(BigDecimal.ZERO);
        }
    }

    private BigDecimal getFinalBizScore(SrcCalcContext context, BigDecimal bizScore) {
        switch (context.getRankCalcType()) {
            case "1": 
            case "2": 
            case "3": 
            case "4": {
                BigDecimal finalBizScore = bizScore.multiply(context.getRatio_biz()).setScale(6, 4);
                if (context.getBizMaxScore().compareTo(BigDecimal.ZERO) > 0 && finalBizScore.compareTo(context.getBizMaxScore()) > 0) {
                    finalBizScore = context.getBizMaxScore();
                }
                if (context.getBizMinScore().compareTo(BigDecimal.ZERO) > 0 && finalBizScore.compareTo(context.getBizMinScore()) < 0) {
                    finalBizScore = context.getBizMinScore();
                }
                return finalBizScore;
            }
        }
        return bizScore;
    }
}

