/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ResultStatusEnums;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;

public class SrcRankCalcRecommend
implements ISrcRankCoreCalc {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.rankAndRecommend(context);
    }

    protected void rankAndRecommend(SrcCalcContext context) {
        DynamicObject[] assessArray = null;
        assessArray = "4".equals(context.getRankCalcType()) ? SrcCalcHelper.sortByRandom(context) : SrcCalcHelper.sortByValueAndTime(context);
        for (int i = 0; i < assessArray.length; ++i) {
            assessArray[i].set("fseq", (Object)(i + 1));
        }
        int rank = 1;
        String presentResult = null;
        if (Arrays.asList(assessArray).stream().anyMatch(e -> e.getBigDecimal("sumscore").compareTo(BigDecimal.ZERO) > 0) || "4".equals(context.getRankCalcType())) {
            for (DynamicObject assessObj : assessArray) {
                boolean isPresent;
                Set<Long> noPassSupplierSet;
                Map<String, Integer> supQtyMap = this.getSupplierQty(context, assessObj);
                Set<Long> supplierSet = this.getCurrSupplierSet(context, context.getIsOverThresholdMap());
                if (supplierSet != null && supplierSet.size() > 0 && supplierSet.contains(assessObj.getLong("supplier_id"))) {
                    assessObj.set("rank", (Object)0);
                    assessObj.set("result", (Object)ResultStatusEnums.NOTRECOMMEND.getValue());
                    continue;
                }
                if (context.getTenderSupplierSet().size() > 0) {
                    String pkg_supKey = null;
                    pkg_supKey = "2".equals(context.getManageType()) && "2".equals(context.getSumType()) ? String.valueOf(assessObj.getLong("package_id")) + '_' + String.valueOf(assessObj.getLong("supplier_id")) : String.valueOf(String.valueOf(assessObj.getLong("supplier_id")));
                    if (!context.getTenderSupplierSet().contains(pkg_supKey)) {
                        assessObj.set("rank", (Object)0);
                        assessObj.set("result", (Object)ResultStatusEnums.NOTRECOMMEND.getValue());
                        continue;
                    }
                }
                if ((noPassSupplierSet = this.getCurrSupplierSet(context, context.getNoPassSupplierMap())) != null && noPassSupplierSet.size() > 0 && noPassSupplierSet.contains(assessObj.getLong("supplier_id"))) {
                    assessObj.set("rank", (Object)0);
                    assessObj.set("result", (Object)ResultStatusEnums.NOPASSAPTITUDE.getValue());
                    continue;
                }
                boolean bl = isPresent = "0".equals(context.getPresentRankType()) && context.getSumType().equals("3") && context.getPresentSet().contains(assessObj.getLong("purlist_id"));
                if (isPresent) {
                    long sourceFlowId;
                    if (null == presentResult && "0".equals(presentResult = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)(sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj().getDynamicObject("srctype"))), (String)"presentRankType2", (Object)"", (long)SrmCommonUtil.getPkValue((DynamicObject)context.getProjectObj())), (String)""))) {
                        presentResult = "";
                    }
                    assessObj.set("rank", (Object)0);
                    assessObj.set("result", presentResult);
                    continue;
                }
                if (rank <= supQtyMap.get("winerqty")) {
                    assessObj.set("result", (Object)ResultStatusEnums.WIN.getValue());
                } else if (rank <= supQtyMap.get("winerqty") + supQtyMap.get("alterqty")) {
                    assessObj.set("result", (Object)ResultStatusEnums.CANDIDATE.getValue());
                } else if (rank <= supQtyMap.get("winerqty") + supQtyMap.get("alterqty") + supQtyMap.get("trainqty")) {
                    assessObj.set("result", (Object)ResultStatusEnums.TRAIN.getValue());
                } else {
                    assessObj.set("result", (Object)ResultStatusEnums.LOSE.getValue());
                }
                assessObj.set("rank", (Object)rank);
                ++rank;
            }
        }
        if (context.getAllAssessList() == null) {
            context.setAllAssessList(Arrays.asList(assessArray));
        } else {
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(context.getAllAssessList());
            tempList.addAll(Arrays.asList(assessArray));
            context.setAllAssessList(tempList);
        }
        context.setAssessArray(null);
        DynamicObject[] manualScoreArray = context.getManualScoreList().toArray(new DynamicObject[0]);
        if (context.getAllManualScoreList() == null) {
            context.setAllManualScoreList(Arrays.asList(manualScoreArray));
        } else {
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(context.getAllManualScoreList());
            tempList.addAll(Arrays.asList(manualScoreArray));
            context.setAllManualScoreList(tempList);
        }
        context.setManualScoreList(null);
    }

    protected Set<Long> getCurrSupplierSet(SrcCalcContext context, Map<String, Set<Long>> supplierMap) {
        if (CollectionUtils.isEmpty(supplierMap)) {
            return null;
        }
        Set<String> keySet = supplierMap.keySet();
        if (CollectionUtils.isEmpty(keySet)) {
            return null;
        }
        String key = this.getCurrGKey(context);
        if (keySet.contains(key)) {
            return supplierMap.get(key);
        }
        return null;
    }

    protected String getCurrGKey(SrcCalcContext context) {
        switch (context.getSumType()) {
            case "3": {
                int index = context.getCurrGKey().lastIndexOf(124);
                return context.getCurrGKey().substring(0, index);
            }
        }
        return context.getCurrGKey();
    }

    private Map<String, Integer> getSupplierQty(SrcCalcContext context, DynamicObject assessObj) {
        long keyId = 0L;
        keyId = context.getRatioKeyField().equals("project") ? assessObj.getLong("billid") : assessObj.getLong(context.getRatioKeyField() + "_id");
        if (context.getRatioKeyField().equals("purlist") && null != context.getEntryid_PurlistidMap() && context.getEntryid_PurlistidMap().size() > 0) {
            keyId = context.getEntryid_PurlistidMap().get(keyId);
        }
        int winerQty = this.getSupplierQty(context.getWinerQtyMap(), keyId, context.getWinerQty());
        int alterQty = this.getSupplierQty(context.getAlterQtyMap(), keyId, context.getAlterQty());
        int trainQty = this.getSupplierQty(context.getTrainQtyMap(), keyId, context.getTrainQty());
        HashMap<String, Integer> supQtyMap = new HashMap<String, Integer>(3);
        supQtyMap.put("winerqty", winerQty);
        supQtyMap.put("alterqty", alterQty);
        supQtyMap.put("trainqty", trainQty);
        return supQtyMap;
    }

    private int getSupplierQty(Map<Long, Integer> qtyMap, long keyId, int defalutValue) {
        if (null == qtyMap || qtyMap.size() == 0 || keyId == 0L) {
            return defalutValue;
        }
        if (null == qtyMap.get(keyId) || qtyMap.get(keyId) == 0) {
            return defalutValue;
        }
        return qtyMap.get(keyId);
    }
}

