/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.src.common.calc.ISrcCalcFacade;
import kd.scm.src.common.calc.ISrcCalculate;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.SrcGlobalCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankCoreCalc;
import kd.scm.src.common.calc.rank.ISrcRankInit;
import kd.scm.src.common.calc.rank.ISrcRankPrepare;
import kd.scm.src.common.calc.rank.ISrcRankProcess;
import kd.scm.src.common.calc.rank.ISrcRankResult;
import kd.scm.src.common.calc.rank.SrcRankAutoCalcBizScore;
import kd.scm.src.common.calc.rank.SrcRankCalcBidBaseScore;
import kd.scm.src.common.calc.rank.SrcRankClearContext;
import kd.scm.src.common.calc.rank.SrcRankInitScheme;
import kd.scm.src.common.calc.rank.SrcRankResetSchemeInfo;
import kd.scm.src.common.calc.rank.SrcRanlCalcAverageValue;

public class SrcRankFacade
implements ISrcCalcFacade {
    private static final long serialVersionUID = 1L;

    @Override
    public void calculate(String entityName, long billId, SrcGlobalCalcContext globalContext, boolean isResetPurlist) {
        SrcCalcHelper.synthCalcVerify(billId, globalContext);
        if (globalContext.getIsAllowSynthCalc() == 0) {
            return;
        }
        SrcCalcContext context = SrcCalcHelper.createContext(entityName, billId, globalContext, isResetPurlist);
        this.initContext(context, ISrcRankInit.class.getSimpleName());
        this.prepareData(context, ISrcRankPrepare.class.getSimpleName());
        if (!context.isIspkgscheme()) {
            SrcRankFacade.getPkgSchemeInfo(context);
            SrcRankFacade.resetPkgSchemeInfo(context);
            this.handleData(context, ISrcRankProcess.class.getSimpleName());
            this.handleResult(context, ISrcRankResult.class.getSimpleName());
            return;
        }
        for (Map.Entry<String, Long> pkgScheme : context.getSchemeMap().entrySet()) {
            SrcRankFacade.clearContextTempData(context);
            context.setPkgGroupId(Long.parseLong(pkgScheme.getKey()));
            context.setPkgSchemeId(pkgScheme.getValue());
            SrcRankFacade.getPkgSchemeInfo(context);
            SrcRankFacade.resetPkgSchemeInfo(context);
            context.setPackageFilter(new QFilter("package.id", "=", (Object)Long.parseLong(pkgScheme.getKey())));
            this.handleData(context, ISrcRankProcess.class.getSimpleName());
            this.handleResult(context, ISrcRankResult.class.getSimpleName());
        }
    }

    public static SrcRankFacade getInstance() {
        return (SrcRankFacade)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRankFacade.class.getName());
    }

    public static void clearContextTempData(SrcCalcContext context) {
        ((ISrcCalculate)ExtPluginFactory.getInstance().getExtPluginInstance(SrcRankClearContext.class.getSimpleName(), SrcRankClearContext.class.getName())).process(context);
    }

    public static void getPkgSchemeInfo(SrcCalcContext context) {
        ((ISrcCalculate)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRankInitScheme.class.getSimpleName(), SrcRankInitScheme.class.getName())).process(context);
    }

    public static void resetPkgSchemeInfo(SrcCalcContext context) {
        ((ISrcCalculate)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRankResetSchemeInfo.class.getSimpleName(), SrcRankResetSchemeInfo.class.getName())).process(context);
    }

    public static void rankCoreCalc(SrcCalcContext context, String pluginNumber) {
        List<ISrcCalculate> srcRankCoreCalcs = SrcRankFacade.getSrcRankCoreCalcs(pluginNumber);
        for (ISrcCalculate srcRankCoreCalc : srcRankCoreCalcs) {
            srcRankCoreCalc.process(context);
        }
    }

    public static List<ISrcCalculate> getSrcRankCoreCalcs(String pluginNumber) {
        return ExtPluginFactory.getInstance().getExtPluginInstancesSingle(pluginNumber, null);
    }

    public static void autoCalcBizSscore(SrcCalcContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(SrcRankAutoCalcBizScore.class.getSimpleName(), SrcRankAutoCalcBizScore.class.getName());
        for (ISrcRankCoreCalc handler : handlers) {
            if (!context.isSucced()) continue;
            handler.process(context);
        }
    }

    public static BigDecimal calcAverageValue(SrcCalcContext context, List<BigDecimal> bizScoreList, BigDecimal sumValue) {
        SrcRanlCalcAverageValue handler = (SrcRanlCalcAverageValue)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRanlCalcAverageValue.class.getSimpleName(), SrcRanlCalcAverageValue.class.getName());
        return handler.calcAverageValue(context, bizScoreList, sumValue);
    }

    public static BigDecimal calcBidBaseScore(SrcCalcContext context, BigDecimal avgValue, Map<String, DynamicObject> baseValueMap, long supplierId, long packageId, long purlistId, long purlistId0) {
        SrcRankCalcBidBaseScore handler = (SrcRankCalcBidBaseScore)ExtPluginFactory.getInstance().getExtPluginInstanceSingle(SrcRankCalcBidBaseScore.class.getSimpleName(), SrcRankCalcBidBaseScore.class.getName());
        return handler.calcBidBaseScore(context, avgValue, baseValueMap, supplierId, packageId, purlistId, purlistId0);
    }
}

