/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankResult;

public class SrcRankHandleLastRank
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        List<DynamicObject> assessList = context.getAllAssessList();
        if (null == assessList || assessList.size() == 0) {
            return;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getBillId());
        qfilter.and("istender", "=", (Object)"1");
        DynamicObject[] supplierRows = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"suppliertype,supplier,package,currentrank,sumscore,bizamount", (QFilter[])qfilter.toArray());
        if (supplierRows.length == 0) {
            return;
        }
        Map<String, List<DynamicObject>> supplierMap = new HashMap<String, List<DynamicObject>>(2);
        Map<String, List<DynamicObject>> assessMap = new HashMap<String, List<DynamicObject>>(2);
        switch (context.getSumType()) {
            case "1": {
                supplierMap = Arrays.asList(supplierRows).stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id")));
                assessMap = assessList.stream().collect(Collectors.groupingBy(e -> e.getString("supplier_id")));
                break;
            }
            case "2": {
                supplierMap = Arrays.asList(supplierRows).stream().collect(Collectors.groupingBy(e -> e.getString("package.id") + '_' + e.getString("supplier.id")));
                assessMap = assessList.stream().collect(Collectors.groupingBy(e -> e.getString("package_id") + '_' + e.getString("supplier_id")));
                break;
            }
            case "3": {
                supplierMap = Arrays.asList(supplierRows).stream().collect(Collectors.groupingBy(e -> e.getString("package.id") + '_' + e.getString("supplier.id")));
                assessMap = assessList.stream().collect(Collectors.groupingBy(e -> e.getString("package_id") + '_' + e.getString("supplier_id")));
                break;
            }
        }
        this.setTenderSupplierValue(supplierMap, assessMap);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])supplierRows);
    }

    protected void setTenderSupplierValue(Map<String, List<DynamicObject>> supplierMap, Map<String, List<DynamicObject>> assessMap) {
        for (Map.Entry<String, List<DynamicObject>> entry : supplierMap.entrySet()) {
            int currentRank = 0;
            BigDecimal sumScore = BigDecimal.ZERO;
            BigDecimal bizAmount = BigDecimal.ZERO;
            DynamicObject[] assessList = null;
            if (null != assessMap.get(entry.getKey())) {
                assessList = assessMap.get(entry.getKey()).toArray(new DynamicObject[assessMap.get(entry.getKey()).size()]);
            }
            if (null != assessList && assessList.length > 0) {
                this.shellSort(assessList);
                currentRank = assessList[0].getInt("rank");
                sumScore = assessList[0].getBigDecimal("sumscore");
                bizAmount = assessList[0].getBigDecimal("bizamount");
            }
            for (DynamicObject obj : entry.getValue()) {
                obj.set("sumscore", (Object)sumScore);
                obj.set("currentrank", (Object)currentRank);
                obj.set("bizamount", (Object)bizAmount);
            }
        }
    }

    public void shellSort(DynamicObject[] arrays) {
        DynamicObject temp = null;
        int index = 0;
        for (int gap = arrays.length / 2; gap > 0; gap /= 2) {
            for (int i = gap; i < arrays.length; ++i) {
                temp = arrays[i];
                for (index = i - gap; index >= 0 && this.isLargeThen(temp, arrays[index], arrays); index -= gap) {
                    arrays[index + gap] = arrays[index];
                }
                if (index + gap == i) continue;
                arrays[index + gap] = temp;
            }
        }
    }

    public boolean isLargeThen(DynamicObject obj1, DynamicObject obj2, DynamicObject[] arrays) {
        BigDecimal score2;
        int rank2;
        int rank1 = obj1.getInt("rank");
        if (rank1 < (rank2 = obj2.getInt("rank"))) {
            return true;
        }
        if (rank1 > rank2) {
            return false;
        }
        BigDecimal score1 = obj1.getBigDecimal("sumscore");
        return score1.compareTo(score2 = obj2.getBigDecimal("sumscore")) >= 0;
    }
}

