/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankResult;
import kd.scm.src.common.calc.rank.SrcRankFacade;

public class SrcRankHandleOptimalPrice
implements ISrcRankResult {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        Object isProcessed = context.getGlobalContext().getCustomMap().get(SrcRankHandleOptimalPrice.class.getSimpleName());
        if (null != isProcessed && isProcessed.toString().equals("1")) {
            return;
        }
        SrcRankFacade.getPkgSchemeInfo(context);
        Map<Long, List<DynamicObject>> purlistMap = this.getUpdatePurlistRows(context);
        Map<Long, DynamicObject> optimalPurlistMap = this.getOptimalPurlistRows(context);
        if (purlistMap.size() == 0 || optimalPurlistMap.size() == 0) {
            return;
        }
        ArrayList purlistList = new ArrayList();
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject optimalPurlist = optimalPurlistMap.get(entry.getKey());
            if (null == optimalPurlist) continue;
            for (DynamicObject row : entry.getValue()) {
                row.set("bestprice", (Object)optimalPurlist.getBigDecimal("locprice"));
                row.set("usdprice", (Object)optimalPurlist.getBigDecimal("loctaxprice"));
            }
            purlistList.addAll(entry.getValue());
        }
        PdsCommonUtils.saveDynamicObjects(purlistList);
        context.getGlobalContext().getCustomMap().put(SrcRankHandleOptimalPrice.class.getSimpleName(), "1");
    }

    private Map<Long, List<DynamicObject>> getUpdatePurlistRows(SrcCalcContext context) {
        String selectFields = "purlist,bestprice,usdprice,locprice,loctaxprice";
        QFilter qfilters = this.getPurlistFilter(context);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray());
        return Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id")));
    }

    private Map<Long, DynamicObject> getOptimalPurlistRows(SrcCalcContext context) {
        String selectFields = "suppliertype,supplier.id,purlist.id,locprice,loctaxprice";
        QFilter qfilters = this.getPurlistFilter(context);
        qfilters.and(new QFilter("locprice", ">", (Object)BigDecimal.ZERO).or("loctaxprice", ">", (Object)BigDecimal.ZERO));
        String taxType = context.getProjectObj().getString("taxtype");
        String orderby = " purlist";
        orderby = "2".equals(context.getRankCalcType()) ? (taxType.equals("2") ? orderby + ", locprice desc, loctaxprice desc" : orderby + ", loctaxprice desc, locprice desc") : (taxType.equals("2") ? orderby + ", locprice, loctaxprice" : orderby + ", loctaxprice, locprice");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray(), (String)orderby);
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
    }

    private QFilter getPurlistFilter(SrcCalcContext context) {
        QFilter qfilters = new QFilter("project", "=", context.getProjectObj().getPkValue());
        qfilters.and("entrystatus", "in", this.getStatusSet());
        return qfilters;
    }

    private Set<String> getStatusSet() {
        HashSet<String> statusSet = new HashSet<String>(4);
        statusSet.add(ProjectStatusEnums.OPENED.getValue());
        statusSet.add(ProjectStatusEnums.CLOSED.getValue());
        return statusSet;
    }
}

