/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankInit;

public class SrcRankInitCompareRule
implements ISrcRankInit {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        this.setIndexRatio(context);
        this.setWinerQty(context);
        this.setBaseValue(context);
        this.setOtherParam(context);
    }

    protected void setIndexRatio(SrcCalcContext context) {
        BigDecimal ratio_tec = context.getCompareCfgObj().getBigDecimal("ratio_tec");
        ratio_tec = ratio_tec.divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        context.setRatio_tec(ratio_tec);
        BigDecimal ratio_oth = context.getCompareCfgObj().getBigDecimal("ratio_oth");
        ratio_oth = ratio_oth.divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        context.setRatio_oth(ratio_oth);
        BigDecimal ratio_biz = context.getCompareCfgObj().getBigDecimal("ratio_biz");
        ratio_biz = ratio_biz.divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        if (ratio_tec.add(ratio_oth).add(ratio_biz).compareTo(BigDecimal.ZERO) <= 0) {
            ratio_biz = BigDecimal.ONE;
        }
        context.setRatio_biz(ratio_biz);
    }

    protected void setWinerQty(SrcCalcContext context) {
        int winerQty = context.getCompareCfgObj().getInt("winerqty");
        if (0 == winerQty) {
            winerQty = 999999;
        }
        context.setWinerQty(winerQty);
        int alterQty = context.getCompareCfgObj().getInt("alterqty");
        context.setAlterQty(alterQty);
    }

    protected void setBaseValue(SrcCalcContext context) {
        BigDecimal bizBaseScoreRatio = BigDecimal.ZERO;
        BigDecimal bizMinScoreRatio = BigDecimal.ZERO;
        if (context.getSchemeObj() != null) {
            bizBaseScoreRatio = context.getSchemeObj().getBigDecimal("basescoreratio");
            bizMinScoreRatio = context.getSchemeObj().getBigDecimal("minscoreratio");
        }
        if (bizBaseScoreRatio.compareTo(BigDecimal.ZERO) <= 0 || bizBaseScoreRatio.compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) > 0) {
            bizBaseScoreRatio = new BigDecimal("100");
        }
        if (bizMinScoreRatio.compareTo(bizBaseScoreRatio) > 0) {
            bizMinScoreRatio = BigDecimal.ZERO;
        }
        context.setBizBaseScoreRatio(bizBaseScoreRatio);
        context.setBizMinScoreRatio(bizMinScoreRatio);
        BigDecimal bizBaseScore = context.getCompareCfgObj().getBigDecimal("basescore");
        if (bizBaseScore.compareTo(BigDecimal.ZERO) <= 0) {
            bizBaseScore = context.getRatio_biz().multiply(context.getBizBaseScoreRatio());
        }
        context.setBizBaseScore(bizBaseScore);
        BigDecimal bizMaxScore = context.getRatio_biz().multiply(BigDecimal.TEN).multiply(BigDecimal.TEN);
        context.setBizMaxScore(bizMaxScore);
        BigDecimal bizMinScore = context.getCompareCfgObj().getBigDecimal("minscore");
        if (bizMinScore.compareTo(BigDecimal.ZERO) <= 0) {
            bizMinScore = context.getRatio_biz().multiply(context.getBizMinScoreRatio());
        }
        context.setBizMinScore(bizMinScore);
    }

    protected void setOtherParam(SrcCalcContext context) {
        DynamicObject bidOpenCfgObj;
        context.setIspkgscheme(context.getCompareCfgObj().getBoolean("ispkgscheme"));
        context.setManualScore(context.getCompareCfgObj().getBoolean("ismanualscore"));
        if (!context.getGlobalContext().isTempCalculate()) {
            context.setBizScore(context.getCompareCfgObj().getBoolean("isbizscore"));
        }
        if (null != (bidOpenCfgObj = QueryServiceHelper.queryOne((String)"src_bidopen_config", (String)"scoretype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getBillId())}))) {
            context.setScoretype(bidOpenCfgObj.getString("scoretype"));
        } else {
            context.setScoretype("1");
        }
    }
}

