/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.rank;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.rank.ISrcRankInit;

public class SrcRankInitScheme
implements ISrcRankInit {
    @Override
    public void process(SrcCalcContext context) {
        long schemeId = context.getPkgSchemeId();
        if (schemeId == 0L) {
            return;
        }
        DynamicObject schemeObj = BusinessDataServiceHelper.loadSingle((Object)context.getPkgSchemeId(), (String)"src_pattern");
        if (schemeObj == null) {
            return;
        }
        context.setSchemeObj(schemeObj);
        context.getGlobalContext().getCustomMap().put("isbydecision", schemeObj.getBoolean("isbydecision"));
        this.setScoreFormula(context, schemeObj);
        this.setSumType(context, schemeObj);
        this.setRankType(context, schemeObj);
        this.setBaseScore(context, schemeObj);
        this.setValueField(context, schemeObj);
        this.setAvgType(context, schemeObj);
        this.setRatioAndWright(context, schemeObj);
        this.setTenderSupplierSet(context);
    }

    protected void setScoreFormula(SrcCalcContext context, DynamicObject schemeObj) {
        if (Objects.nonNull(schemeObj)) {
            String scoreFormula = schemeObj.getString("scoreformula");
            if (null == scoreFormula || scoreFormula.trim().length() == 0) {
                scoreFormula = "1";
            }
            context.setScoreFormula(scoreFormula);
            BigDecimal scorePara = schemeObj.getBigDecimal("scorepara");
            if (scorePara.compareTo(BigDecimal.ZERO) == 0) {
                scorePara = BigDecimal.ONE;
            }
            context.setScorePara(scorePara);
        }
    }

    protected void setSumType(SrcCalcContext context, DynamicObject schemeObj) {
        String sumType = null;
        if (schemeObj != null) {
            sumType = schemeObj.getString("sumtype");
        }
        if (sumType == null || "".equals(sumType.trim())) {
            sumType = "1";
        }
        context.setSumType(sumType);
    }

    protected void setRankType(SrcCalcContext context, DynamicObject schemeObj) {
        String rankType = null;
        if (schemeObj != null) {
            rankType = schemeObj.getString("ranktype");
        }
        if (rankType == null || "".equals(rankType.trim())) {
            rankType = "1";
        }
        context.setRankCalcType(rankType);
    }

    protected void setBaseScore(SrcCalcContext context, DynamicObject schemeObj) {
        BigDecimal baseScore = BigDecimal.ZERO;
        if (schemeObj != null) {
            baseScore = schemeObj.getBigDecimal("basescore");
        }
        if (baseScore.compareTo(BigDecimal.ZERO) <= 0) {
            baseScore = BigDecimal.TEN.multiply(BigDecimal.TEN);
        }
        context.setBaseScore(baseScore);
    }

    protected void setValueField(SrcCalcContext context, DynamicObject schemeObj) {
        String valueField = null;
        if (schemeObj != null) {
            valueField = schemeObj.getString("valuefield");
            context.setLargeZero(schemeObj.getBoolean("islargezero"));
        }
        if (valueField == null || "".equals(valueField.trim())) {
            valueField = "amount";
        }
        context.setValueField(valueField);
    }

    protected void setAvgType(SrcCalcContext context, DynamicObject schemeObj) {
        String avgType = null;
        if (schemeObj != null) {
            avgType = schemeObj.getString("avgtype");
        }
        if (avgType == null || "".equals(avgType.trim())) {
            avgType = "1";
        }
        context.setAvgType(avgType);
    }

    protected void setRatioAndWright(SrcCalcContext context, DynamicObject schemeObj) {
        HashMap<String, BigDecimal> ratioMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>(16);
        if (Objects.nonNull(schemeObj)) {
            DynamicObjectCollection rows = schemeObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                BigDecimal weight;
                long packageId = row.getLong("package.id");
                long purlistId = row.getLong("purlist.id");
                BigDecimal ratio = row.getBigDecimal("ratio");
                if (ratio.compareTo(BigDecimal.ZERO) == 0) {
                    ratio = BigDecimal.ONE;
                }
                weight = (weight = row.getBigDecimal("weight")).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : weight.divide(BigDecimal.TEN).divide(BigDecimal.TEN);
                if (packageId > 0L) {
                    ratioMap.put(String.valueOf(packageId), ratio);
                    weightMap.put(String.valueOf(packageId), weight);
                }
                if (purlistId <= 0L) continue;
                ratioMap.put(String.valueOf(purlistId), ratio);
                weightMap.put(String.valueOf(purlistId), weight);
            }
        }
        context.setRatioMap(ratioMap);
        context.setWeightMap(weightMap);
    }

    protected void setTenderSupplierSet(SrcCalcContext context) {
        QFilter supFilter = new QFilter("billid", "=", (Object)context.getBillId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"package.id,supplier.id", (QFilter[])supFilter.toArray());
        if (rows.size() == 0) {
            return;
        }
        Set<String> tenderSupplierSet = null;
        tenderSupplierSet = "2".equals(context.getManageType()) && "2".equals(context.getSumType()) ? rows.stream().map(e -> String.valueOf(e.getLong("package.id")) + '_' + String.valueOf(e.getLong("supplier.id"))).collect(Collectors.toSet()) : rows.stream().map(e -> String.valueOf(e.getLong("supplier.id"))).collect(Collectors.toSet());
        context.setTenderSupplierSet(tenderSupplierSet);
    }
}

