/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.ratio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCurrencyUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.ratio.ISrcRatioProcess;
import kd.scm.src.common.enums.SrcDecisionEnum;

public class SrcRatioCalculate
implements ISrcRatioProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        if (context.getRatioValueMap() == null) {
            return;
        }
        String locCurrencyId = String.valueOf(context.getLocCurrencyId());
        ArrayList<DynamicObject> winSupplierObjs = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> signSupplierObjs = new ArrayList<DynamicObject>(16);
        HashMap precisionMap = new HashMap(2);
        for (String key : context.getRatioValueMap().keySet()) {
            Map<String, Object> idMap = SrcCalcHelper.getRatioObjectIdFromKey(key);
            long supplierId = PdsCommonUtils.object2Long((Object)idMap.get("supplierid"));
            long projectId = PdsCommonUtils.object2Long((Object)idMap.get("projectid"));
            long packageId = PdsCommonUtils.object2Long((Object)idMap.get("packageid"));
            long cagetoryId = PdsCommonUtils.object2Long((Object)idMap.get("categoryid"));
            Map<String, BigDecimal> keyMap = context.getRatioValueMap().get(key);
            BigDecimal locAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)keyMap.get("locamount"), (String)locCurrencyId, precisionMap);
            BigDecimal locTaxAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)keyMap.get("loctaxamount"), (String)locCurrencyId, precisionMap);
            BigDecimal locAmount2 = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)keyMap.get("locamount2"), (String)locCurrencyId, precisionMap);
            BigDecimal locTaxAmount2 = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)keyMap.get("loctaxamount2"), (String)locCurrencyId, precisionMap);
            String gKey = idMap.get("projectid") + "|" + idMap.get("packageid") + "|" + idMap.get("categoryid");
            Map<String, BigDecimal> gKeyMap = context.getRatioGValueMap().get(gKey);
            BigDecimal gAmount = gKeyMap.get("amount");
            BigDecimal gTaxAmount = gKeyMap.get("taxamount");
            BigDecimal glocAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)gKeyMap.get("locamount"), (String)locCurrencyId, precisionMap);
            BigDecimal glocTaxAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)gKeyMap.get("loctaxamount"), (String)locCurrencyId, precisionMap);
            if (gAmount.compareTo(BigDecimal.ZERO) <= 0) {
                gAmount = BigDecimal.ONE;
            }
            if (gTaxAmount.compareTo(BigDecimal.ZERO) <= 0) {
                gTaxAmount = BigDecimal.ONE;
            }
            if (!context.isAllSupplier() && keyMap.get("result").compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject entryObj = this.createEntryObj(context, supplierId, projectId, packageId, cagetoryId);
            if (keyMap.get("result").compareTo(BigDecimal.ZERO) == 0) {
                entryObj.set("result", (Object)"2");
            }
            DynamicObject subentryObj = this.createSubEntryObj(context, entryObj, supplierId);
            this.calcOrderRatio(context, entryObj, subentryObj, glocAmount, glocTaxAmount, locAmount, locTaxAmount);
            entryObj.set("locamount", (Object)locAmount2);
            entryObj.set("loctaxamount", (Object)locTaxAmount2);
            winSupplierObjs.add(entryObj);
            signSupplierObjs.add(subentryObj);
        }
        String rankCalcType = context.getSchemeObj() == null ? "1" : context.getSchemeObj().getString("ranktype");
        List<DynamicObject> sList = this.rankByPak_Ratio_sup(winSupplierObjs, rankCalcType);
        int indexSeq = 1;
        for (DynamicObject winSupplierObj : sList) {
            winSupplierObj.set("fseq", (Object)indexSeq++);
        }
        if (winSupplierObjs != null && winSupplierObjs.size() > 0) {
            context.setWinSupplierObjs(winSupplierObjs.toArray(new DynamicObject[winSupplierObjs.size()]));
        }
        if (signSupplierObjs != null && signSupplierObjs.size() > 0) {
            context.setSignSupplierObjs(signSupplierObjs.toArray(new DynamicObject[signSupplierObjs.size()]));
        }
    }

    private List<DynamicObject> rankByPak_Ratio_sup(List<DynamicObject> unSortedobjs, final String rankCalcType) {
        List<DynamicObject> sortedobjs = unSortedobjs;
        Collections.sort(sortedobjs, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject e1, DynamicObject e2) {
                long pkgId2;
                long pkgId1 = e1.getLong("package.id");
                if (pkgId1 == (pkgId2 = e2.getLong("package.id"))) {
                    BigDecimal ratio_e2;
                    BigDecimal ratio_e1 = e1.getBigDecimal("orderratio");
                    if (ratio_e1.compareTo(ratio_e2 = e2.getBigDecimal("orderratio")) == 0) {
                        BigDecimal taxRatio_e2;
                        BigDecimal taxRatio_e1 = e1.getBigDecimal("orderratio1");
                        if (taxRatio_e1.compareTo(taxRatio_e2 = e2.getBigDecimal("orderratio1")) == 0) {
                            BigDecimal locAmount_e2;
                            BigDecimal locAmount_e1 = e1.getBigDecimal("locamount");
                            if (locAmount_e1.compareTo(locAmount_e2 = e2.getBigDecimal("locamount")) == 0) {
                                BigDecimal locTaxAmount_e2;
                                BigDecimal locTaxAmount_e1 = e1.getBigDecimal("loctaxamount");
                                if (locTaxAmount_e1.compareTo(locTaxAmount_e2 = e2.getBigDecimal("loctaxamount")) == 0) {
                                    long supId1 = e1.getLong("supplier.id");
                                    long supId2 = e2.getLong("supplier.id");
                                    return supId2 - supId1 <= 0L ? 0 : -1;
                                }
                                if ("2".equals(rankCalcType)) {
                                    return locTaxAmount_e2.compareTo(locTaxAmount_e1);
                                }
                                return locTaxAmount_e1.compareTo(locTaxAmount_e2);
                            }
                            if ("2".equals(rankCalcType)) {
                                return locAmount_e2.compareTo(locAmount_e1);
                            }
                            return locAmount_e1.compareTo(locAmount_e2);
                        }
                        return taxRatio_e2.compareTo(taxRatio_e1);
                    }
                    return ratio_e2.compareTo(ratio_e1);
                }
                return pkgId2 - pkgId1 < 0L ? 0 : -1;
            }
        });
        return sortedobjs;
    }

    protected DynamicObject createEntryObj(SrcCalcContext context, long supplierId, long projectId, long packageId, long cagetoryId) {
        DynamicObject entryObj = null;
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getCompBillId());
        qfilter.and("supplier_id", "=", (Object)supplierId);
        qfilter.and("package_id", "=", (Object)packageId);
        qfilter.and("category_id", "=", (Object)cagetoryId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"src_decisionsumsup", (String)"id", (QFilter[])qfilter.toArray());
        if (null != obj) {
            entryObj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"src_decisionsumsup");
        } else {
            entryObj = BusinessDataServiceHelper.newDynamicObject((String)"src_decisionsumsup");
            ORM.create().setPrimaryKey(entryObj);
            entryObj.set("billid", (Object)context.getCompBillId());
            entryObj.set("supplier_id", (Object)supplierId);
            entryObj.set("suppliertype", (Object)context.getSupTypeMap().get(String.valueOf(supplierId)));
            entryObj.set("package_id", (Object)packageId);
            entryObj.set("project_id", (Object)projectId);
            entryObj.set("category_id", (Object)cagetoryId);
            entryObj.set("contracttype", (Object)SrcDecisionEnum.TWO_SIDES.getCode());
        }
        if ("src_predecision".equals(context.getEntityName())) {
            entryObj.set("result", (Object)"3");
        } else {
            entryObj.set("result", (Object)"1");
        }
        entryObj.set("project", context.getProjectObj().getPkValue());
        entryObj.set("parentid", context.getProjectObj().getPkValue());
        return entryObj;
    }

    protected DynamicObject createSubEntryObj(SrcCalcContext context, DynamicObject entryObj, long supplierId) {
        DynamicObject subentryObj = BusinessDataServiceHelper.newDynamicObject((String)"src_decisionsumsign");
        subentryObj.set("billid", entryObj.getPkValue());
        subentryObj.set("fseq", (Object)1);
        subentryObj.set("supplier_id", (Object)supplierId);
        subentryObj.set("suppliertype", (Object)context.getSupTypeMap().get(String.valueOf(supplierId)));
        subentryObj.set("signrate", (Object)100);
        return subentryObj;
    }

    protected void calcOrderRatio(SrcCalcContext context, DynamicObject entryObj, DynamicObject subentryObj, BigDecimal glocAmount, BigDecimal glocTaxAmount, BigDecimal locAmount, BigDecimal locTaxAmount) {
        entryObj.set("amount", (Object)locAmount);
        entryObj.set("taxamount", (Object)locTaxAmount);
        if (glocAmount.compareTo(BigDecimal.ZERO) == 0) {
            entryObj.set("orderratio", (Object)0);
        } else {
            entryObj.set("orderratio", (Object)locAmount.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).divide(glocAmount, 4, 4));
        }
        if (glocTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
            entryObj.set("orderratio1", (Object)0);
        } else {
            entryObj.set("orderratio1", (Object)locTaxAmount.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN).divide(glocTaxAmount, 4, 4));
        }
        subentryObj.set("amount", (Object)locAmount);
        subentryObj.set("taxamount", (Object)locTaxAmount);
    }
}

