/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.total;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.total.ISrcTotalProcess;

public class SrcTotalCalcBaseQty
implements ISrcTotalProcess {
    @Override
    public void process(SrcCalcContext context) {
        if (context.getPurlistObjs() == null) {
            return;
        }
        for (DynamicObject purListObj : context.getPurlistObjs()) {
            DynamicObject baseUnitObj = purListObj.getDynamicObject("baseunit");
            DynamicObject materialObj = purListObj.getDynamicObject("material");
            DynamicObject unitObj = purListObj.getDynamicObject("unit");
            BigDecimal qty = purListObj.getBigDecimal("qty");
            BigDecimal cfmQty = purListObj.getBigDecimal("cfmqty");
            if (Objects.isNull(baseUnitObj)) {
                if (Objects.isNull(materialObj)) {
                    purListObj.set("baseunit", (Object)unitObj);
                    baseUnitObj = unitObj;
                } else {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)materialObj.getPkValue(), (String)"bd_material", (String)"id,baseunit");
                    purListObj.set("baseunit", (Object)obj.getDynamicObject("baseunit"));
                    baseUnitObj = obj.getDynamicObject("baseunit");
                }
            }
            purListObj.set("baseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)qty, (DynamicObject)baseUnitObj));
            purListObj.set("cfmbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)cfmQty, (DynamicObject)baseUnitObj));
        }
    }
}

