/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.total;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCurrencyUtil;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.calc.total.ISrcTotalProcess;

public class SrcTotalCalcSumAmt
implements ISrcTotalProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        DynamicObject[] purlistObjs = context.getPurlistObjs();
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        if (null == context.getRatioType()) {
            DynamicObject ratioRuleObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)"src_project_rule");
            context.setRatioType(PdsCommonUtils.object2String((Object)ratioRuleObj.get("ratiotype"), (String)"1"));
        }
        boolean isByDecision = PdsCommonUtils.object2Boolean((Object)context.getGlobalContext().getCustomMap().get("isbydecision"));
        HashMap precisionMap = new HashMap(2);
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>(2);
        amountMap.put("sumamount", BigDecimal.ZERO);
        amountMap.put("sumtaxamount", BigDecimal.ZERO);
        for (DynamicObject purlistObj : purlistObjs) {
            if (isByDecision) {
                this.calcAmountByDecisionAmount(amountMap, purlistObj);
                continue;
            }
            if ("9".equals(context.getRatioType())) {
                this.calcAmountByCfmQty(amountMap, purlistObj);
                continue;
            }
            this.calcAmountByRatio(amountMap, purlistObj);
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        QFilter qfilters = new QFilter("parentid", "=", (Object)String.valueOf(context.getBillId()));
        qfilters.and("sumtype", "=", (Object)"2");
        DynamicObject sumObj = BusinessDataServiceHelper.loadSingle((String)"src_decisionsum_sup", (String)"entryentity,entryentity.amount,entryentity.taxamount", (QFilter[])qfilters.toArray());
        if (null != sumObj) {
            DynamicObjectCollection rows = sumObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                sumAmount = sumAmount.add(row.getBigDecimal("amount"));
                sumTaxAmount = sumTaxAmount.add(row.getBigDecimal("taxamount"));
            }
        } else {
            sumAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)((BigDecimal)amountMap.get("sumamount")), (String)String.valueOf(context.getLocCurrencyId()), precisionMap);
            sumTaxAmount = SrcCurrencyUtil.convertAmountMoneyByCurr((BigDecimal)((BigDecimal)amountMap.get("sumtaxamount")), (String)String.valueOf(context.getLocCurrencyId()), precisionMap);
        }
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillId(), (String)context.getEntityName(), (String)"sumamount,sumtaxamount,isedited");
        billObj.set("sumamount", (Object)sumAmount);
        billObj.set("sumtaxamount", (Object)sumTaxAmount);
        if (null != billObj.getDynamicObjectType().getProperty("isedited")) {
            billObj.set("isedited", (Object)Boolean.FALSE);
        }
        context.setBillObjs(new DynamicObject[]{billObj});
    }

    private void calcAmountByDecisionAmount(Map<String, BigDecimal> amountMap, DynamicObject purlistObj) {
        this.calcSumAmount(amountMap, purlistObj.getBigDecimal("price6"), purlistObj.getBigDecimal("price7"));
    }

    private void calcAmountByCfmQty(Map<String, BigDecimal> amountMap, DynamicObject purlistObj) {
        int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
        BigDecimal qtyRatio = SrcCalcHelper.getQtyRatio(purlistObj);
        BigDecimal amount = qtyRatio.multiply(purlistObj.getBigDecimal("locamount")).setScale(locPrecision, RoundingMode.HALF_UP);
        BigDecimal taxAmount = qtyRatio.multiply(purlistObj.getBigDecimal("loctaxamount")).setScale(locPrecision, RoundingMode.HALF_UP);
        this.calcSumAmount(amountMap, amount, taxAmount);
    }

    private void calcAmountByRatio(Map<String, BigDecimal> amountMap, DynamicObject purlistObj) {
        int locPrecision = SrcCalcHelper.getPrecision(purlistObj, "loccurr");
        BigDecimal orderRatio = SrcCalcHelper.getOrderRatio(purlistObj);
        BigDecimal amount = orderRatio.multiply(purlistObj.getBigDecimal("locamount")).setScale(locPrecision, RoundingMode.HALF_UP);
        BigDecimal taxAmount = orderRatio.multiply(purlistObj.getBigDecimal("loctaxamount")).setScale(locPrecision, RoundingMode.HALF_UP);
        this.calcSumAmount(amountMap, amount, taxAmount);
    }

    private void calcSumAmount(Map<String, BigDecimal> amountMap, BigDecimal amount, BigDecimal taxAmount) {
        BigDecimal sumAmount = amountMap.get("sumamount").add(amount);
        BigDecimal sumTaxAmount = amountMap.get("sumtaxamount").add(taxAmount);
        amountMap.put("sumamount", sumAmount);
        amountMap.put("sumtaxamount", sumTaxAmount);
    }
}

