/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.calc.total;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcContext;
import kd.scm.src.common.calc.total.ISrcTotalProcess;
import org.apache.commons.lang3.StringUtils;

public class SrcTotalHandleInvalidData
implements ISrcTotalProcess {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcCalcContext context) {
        DynamicObject[] rows = this.getAllPurlistObjs(context);
        if (rows.length == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistObjs = new ArrayList<DynamicObject>(rows.length);
        this.handleLostPurlist(rows, purlistObjs);
        PdsCommonUtils.saveDynamicObjects(purlistObjs);
    }

    protected void handleLostPurlist(DynamicObject[] rows, List<DynamicObject> purlistObjs) {
        Object orderRatioObj = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
        String orderRatioStr = String.valueOf(orderRatioObj == null ? ",1,2,5," : orderRatioObj);
        List orderRatioList = Arrays.stream(orderRatioStr.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        for (DynamicObject row : rows) {
            if (orderRatioList.contains(row.getString("result")) || row.getBigDecimal("price4").compareTo(BigDecimal.ZERO) <= 0 && row.getBigDecimal("price5").compareTo(BigDecimal.ZERO) <= 0) continue;
            row.set("price4", (Object)0);
            row.set("price5", (Object)0);
            row.set("price6", (Object)0);
            row.set("price7", (Object)0);
            purlistObjs.add(row);
        }
    }

    protected DynamicObject[] getAllPurlistObjs(SrcCalcContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)context.getBillId());
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and("entrystatus", "=", (Object)"C");
        qFilter.and("isdecision", "=", (Object)"0");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)Boolean.FALSE);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilter.toArray());
    }
}

