/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.util.PdsAptitudeUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcAptitudeDateValidatorService
implements IDataValidateService {
    private static final long serialVersionUID = -2404236449167779325L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = SrcBidChangeUtil.commonValidate(validateEvent, "src_timechg");
        if (!result.isSuccess()) {
            return result;
        }
        DynamicObject compDataObj = result.getChgCompObj();
        Date aptitudeDate = compDataObj.getDate("newaptitudedate");
        if (null == aptitudeDate) {
            return result;
        }
        Date currentDate = TimeServiceHelper.now();
        Date stopBidDate = compDataObj.getDate("newstopbiddate");
        if (null == stopBidDate) {
            stopBidDate = compDataObj.getDate("stopbiddate");
        }
        StringBuilder message = new StringBuilder();
        if (PdsAptitudeUtils.isOpenApt((DynamicObject)result.getProjectObj(), (String)"isaptopen")) {
            message.append(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u5f00\u8d44\u5ba1\u6807\uff0c\u8bf7\u52ff\u53d1\u8d77\u53d8\u66f4\u3002", (String)"SrcAptitudeDateValidatorService_0", (String)"scm-src-common", (Object[])new Object[0]));
        }
        if (!aptitudeDate.after(currentDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u8d44\u5ba1\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcAptitudeDateValidatorService_1", (String)"scm-src-common", (Object[])new Object[0]), DateUtil.date2str((Date)aptitudeDate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.date2str((Date)currentDate, (String)"yyyy-MM-dd HH:mm:ss")));
        }
        if (stopBidDate != null && !aptitudeDate.before(stopBidDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u8d44\u5ba1\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u6295\u6807\u622a\u6b62\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcAptitudeDateValidatorService_2", (String)"scm-src-common", (Object[])new Object[0]), DateUtil.date2str((Date)aptitudeDate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.date2str((Date)stopBidDate, (String)"yyyy-MM-dd HH:mm:ss")));
        }
        if (message.length() > 0) {
            result.setSuccess(false);
            result.setMessage(message.toString());
        }
        return result;
    }
}

