/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.enums.PdsLettersTypeEnum;
import kd.scm.src.common.util.SrcWinruleUtils;

public class SrcBidNumResValidateService
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = new ValidateResult();
        this.validateChgData(validateEvent, result);
        return result;
    }

    private void validateChgData(ValidateEvent validateEvent, ValidateResult result) {
        if (!result.isSuccess()) {
            return;
        }
        Map paramMap = validateEvent.getParams();
        if (CollectionUtils.isEmpty((Map)paramMap)) {
            return;
        }
        Object decisionChgCompObj = paramMap.get("src_decisionchg");
        if (decisionChgCompObj instanceof DynamicObject) {
            DynamicObject decisionCompData = (DynamicObject)decisionChgCompObj;
            DynamicObjectCollection rows = decisionCompData.getDynamicObjectCollection("entryentity");
            int rowCount = rows.size();
            if (rowCount == 0) {
                this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u53d8\u66f4\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4\u3002", (String)"SrcBidNumResValidateService_6", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
            if (!rows.stream().anyMatch(e -> e.getBoolean("isnew"))) {
                this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u6570\u636e\u65e0\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4\u3002", (String)"SrcBidNumResValidateService_4", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
            int unRecommandCount = 0;
            for (DynamicObject row : rows) {
                String result_New = row.getString("result_new");
                if (!"6".equals(result_New)) continue;
                ++unRecommandCount;
            }
            if (rowCount == unRecommandCount) {
                this.getUnSuccedResult(result, ResManager.loadKDString((String)"\u4e0d\u80fd\u5168\u90e8\u8bbe\u7f6e\u4e3a\u4e0d\u63a8\u8350\u3002", (String)"SrcBidNumResValidateService_1", (String)"scm-src-common", (Object[])new Object[0]));
                return;
            }
        }
        this.verifyOrderRatio(validateEvent, result);
    }

    private void verifyOrderRatio(ValidateEvent validateEvent, ValidateResult result) {
        if (!result.isSuccess()) {
            return;
        }
        StringBuilder materialName = new StringBuilder();
        Map paramMap = validateEvent.getParams();
        if (CollectionUtils.isEmpty((Map)paramMap)) {
            return;
        }
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)((DynamicObject)validateEvent.getObj().get("project")));
        if (!SrcWinruleUtils.isNeedValidateOrderRatio(projectId)) {
            return;
        }
        Object decisionChgCompObj = paramMap.get("src_decisionchg");
        if (decisionChgCompObj instanceof DynamicObject) {
            DynamicObject decisionCompData = (DynamicObject)decisionChgCompObj;
            DynamicObjectCollection rows = decisionCompData.getDynamicObjectCollection("entryentity");
            String orderRatio = (String)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"orderratio");
            List orderRatioIndex = Arrays.stream(orderRatio.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            Boolean orderRatioIsBreak = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result_new"))).anyMatch(e -> BigDecimal.ZERO.compareTo(e.getBigDecimal("orderratio_new")) == 0);
            if (orderRatioIsBreak.booleanValue()) {
                String message = orderRatioIndex.stream().map(str -> PdsLettersTypeEnum.fromVal((String)str).getName()).collect(Collectors.joining("/"));
                this.getUnSuccedResult(result, String.format(ResManager.loadKDString((String)"%1$s\u4f9b\u5e94\u5546\u4efd\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SrcBidNumResValidateService_2", (String)"scm-src-common", (Object[])new Object[0]), message));
                return;
            }
            Map<String, List<DynamicObject>> packageNameMap = rows.stream().filter(row -> orderRatioIndex.contains(row.getString("result_new"))).collect(Collectors.groupingBy(row -> row.getString("package.id")));
            for (Map.Entry<String, List<DynamicObject>> packageNameEntry : packageNameMap.entrySet()) {
                Map<String, List<DynamicObject>> materialNameMap = packageNameEntry.getValue().stream().collect(Collectors.groupingBy(row -> row.getString("purlist.id")));
                for (Map.Entry<String, List<DynamicObject>> materialNameEntry : materialNameMap.entrySet()) {
                    BigDecimal sum = materialNameEntry.getValue().stream().map(e -> e.getBigDecimal("orderratio_new")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (sum.compareTo(new BigDecimal(100)) == 0) continue;
                    materialName.append(',').append(materialNameEntry.getValue().get(0).getString("purlist.materialnane"));
                }
            }
            if (materialName.length() > 0) {
                this.getUnSuccedResult(result, String.format(ResManager.loadKDString((String)"\u6807\u7684\u540d\u79f0\u4e3a%1$s\u591a\u4e2a\u4f9b\u5e94\u5546\u4e2d\u6807\u4efd\u989d\u4e4b\u548c\u5fc5\u987b\u4e3a100%2$s", (String)"SrcBidNumResValidateService_5", (String)"scm-src-common", (Object[])new Object[0]), materialName.substring(1), "%\u3002"));
            }
        }
    }
}

