/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import org.apache.commons.lang3.StringUtils;

public class SrcBidProjectEndHandleFlowNode
implements IDataHandleService {
    private static final long serialVersionUID = 4779904550923800796L;

    public void addNoFolowNode(List<String> entityNameList) {
        entityNameList.add("src_scorertask");
    }

    public void addSpecialEntity(List<String> specialEntityList) {
        specialEntityList.add("tnd_tenderbill");
        specialEntityList.add("tnd_quotebill");
        specialEntityList.add("tnd_negotiatebill");
        specialEntityList.add("src_scoretask");
    }

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        String bizType = null;
        DynamicObject projectEndObj = BusinessDataServiceHelper.loadSingle((String)"src_projectend", (String)"biztype,currentnode", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(bidChangeObj.getPkValue()))});
        if (null != projectEndObj) {
            bizType = projectEndObj.getString("biztype");
        }
        if (null == bizType || "".equals(bizType.trim())) {
            bizType = ProcessStatusEnums.CLOSED.getValue();
        }
        this.handleFlowNode(projectId, bizType);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandleFlowNode_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void handleFlowNode(long projectId, String bizType) {
        DynamicObject node = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        List<String> entityNameList = SrcBidCompTplUtil.getProcessingOrHandledBizObjs(node);
        this.addNoFolowNode(entityNameList);
        for (int i = 0; i < entityNameList.size(); ++i) {
            String entityName = entityNameList.get(i);
            if (StringUtils.isEmpty((CharSequence)entityName) || entityName.trim().length() == 0) continue;
            DynamicObject[] billObjs = this.getBillObj(projectId, entityName);
            this.handleBillObj(billObjs, bizType);
        }
    }

    private DynamicObject[] getBillObj(long projectId, String entityName) {
        ArrayList<String> specialEntityList = new ArrayList<String>(8);
        this.addSpecialEntity(specialEntityList);
        if (specialEntityList.contains(entityName)) {
            return BusinessDataServiceHelper.load((String)entityName, (String)"id,billno,billstatus,bizstatus,project.id", (QFilter[])new QFilter[]{new QFilter("project.id", "=", (Object)projectId)});
        }
        return BusinessDataServiceHelper.load((String)entityName, (String)"id,billno,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
    }

    private void handleBillObj(DynamicObject[] billObjs, String bizType) {
        if (null != billObjs && billObjs.length > 0) {
            ArrayList<String> specialEntityList = new ArrayList<String>(8);
            this.addSpecialEntity(specialEntityList);
            for (DynamicObject billObj : billObjs) {
                String bizStatus = billObj.getString("bizstatus");
                String entityName = billObj.getDynamicObjectType().getName();
                if (Objects.equals(entityName, "src_placeonfile") || bizStatus.trim().length() == 0 || !specialEntityList.contains(entityName) && SrcBizStatusEnum.NOTSTART.getVal().equals(bizStatus)) continue;
                billObj.set("billstatus", (Object)ProcessStatusEnums.PROCESSED.getValue());
                billObj.set("bizstatus", (Object)bizType);
            }
            SaveServiceHelper.save((DynamicObject[])billObjs);
        }
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

