/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.MyTaskStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidProjectEndHandleMyTaskStatus
implements IDataHandleService {
    private static final long serialVersionUID = 4779904550923800796L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        this.updateMyTaskStatus(projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandleMyTaskStatus_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void updateMyTaskStatus(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("entrystatus", "!=", (Object)MyTaskStatusEnums.TERMINATED.getValue());
        DynamicObject[] myTaskObjs = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"entrystatus", (QFilter[])qfilter.toArray());
        if (null == myTaskObjs || myTaskObjs.length == 0) {
            return;
        }
        for (DynamicObject myTaskObj : myTaskObjs) {
            myTaskObj.set("entrystatus", (Object)MyTaskStatusEnums.TERMINATED.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])myTaskObjs);
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

