/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.calc.SrcCalcHelper;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidProjectEndHandlePurlistStatus
implements IDataHandleService {
    private static final long serialVersionUID = 4779904550923800796L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        String bizType = null;
        DynamicObject projectEndObj = BusinessDataServiceHelper.loadSingle((String)"src_projectend", (String)"biztype,currentnode", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(bidChangeObj.getPkValue()))});
        if (null != projectEndObj) {
            bizType = projectEndObj.getString("biztype");
        }
        if (null == bizType || "".equals(bizType.trim())) {
            bizType = ProcessStatusEnums.CLOSED.getValue();
        }
        this.updatePurlistStatus(projectId, bizType);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandlePurlistStatus_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void updatePurlistStatus(long projectId, String bizType) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"entrystatus", (QFilter[])qfilter.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        for (DynamicObject purlistObj : purlistObjs) {
            purlistObj.set("entrystatus", (Object)ProjectStatusEnums.TERMINATED.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistObjs);
        SrcCalcHelper.syntheticalCalculate("src_compare", projectId);
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

