/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcBidProjectEndHandleVieStatus
implements IDataHandleService {
    private static final long serialVersionUID = 4779901550923200713L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        long projectId = bidChangeObj.getDynamicObject("project").getLong("id");
        this.updateVieStatus(projectId);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcBidProjectEndHandleVieStatus_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    public void updateVieStatus(long projectId) {
        if (!QueryServiceHelper.exists((String)"src_vie_rule", (Object)projectId)) {
            return;
        }
        DynamicObject vieRuleObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_vie_rule");
        if (Objects.isNull(vieRuleObj)) {
            return;
        }
        vieRuleObj.set("bidstatus", (Object)SrcVieStatusEnums.EVALUATING.getValue());
        DynamicObject turnsObj = PdsVieHelper.getLastVieTurnsObj((DynamicObject)vieRuleObj, null);
        if (null != turnsObj) {
            turnsObj.set("turnsbidstatus", (Object)SrcVieStatusEnums.EVALUATING.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])new DynamicObject[]{vieRuleObj});
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

