/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;

public class SrcBidSchemeChgScoreStatusValidator
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = new ValidateResult();
        DynamicObject projectObj = (DynamicObject)validateEvent.getObj().get("project");
        if (null == projectObj) {
            return this.getUnSuccedResult(result, "");
        }
        Map params = validateEvent.getParams();
        Object newBidSchemeObj = params.get("src_bidschemechg");
        if (null == newBidSchemeObj) {
            return this.getUnSuccedResult(result, "");
        }
        DynamicObjectCollection newBidSchemeRows = ((DynamicObject)newBidSchemeObj).getDynamicObjectCollection("entryentity");
        HashSet<Long> entryIds = new HashSet<Long>(1);
        for (DynamicObject newBidSchemeRow : newBidSchemeRows) {
            long newSchemeId = newBidSchemeRow.getLong("newscheme.id");
            DynamicObjectCollection newscorer = (DynamicObjectCollection)newBidSchemeRow.get("newscorer");
            if (newSchemeId == 0L && newscorer.size() == 0) continue;
            entryIds.add(newBidSchemeRow.getLong("srcentryid"));
        }
        QFilter qfilter = new QFilter("project.id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        qfilter.and(new QFilter("scored", "=", (Object)"1"));
        qfilter.and(new QFilter("isautoscore", "=", (Object)"0"));
        qfilter.and(new QFilter("srcentryid", "in", entryIds));
        qfilter.and("billid.bizstatus", "!=", (Object)"E");
        if (!QueryServiceHelper.exists((String)"src_scoreanalyse", (QFilter[])qfilter.toArray())) {
            result.setSuccess(true);
            return result;
        }
        DynamicObject[] scoreAnalyseObj = BusinessDataServiceHelper.load((String)"src_scoreanalyse", (String)"billid,package", (QFilter[])qfilter.toArray());
        HashMap<String, String> schemeMap = new HashMap<String, String>(1);
        HashMap<String, String> packageMap = new HashMap<String, String>(1);
        for (int i = 0; i < scoreAnalyseObj.length; ++i) {
            String packageName = scoreAnalyseObj[i].getString("package.packagename");
            String schemeName = scoreAnalyseObj[i].getString("billid.scheme.name");
            if (schemeMap.containsKey(packageName + schemeName) && schemeMap.containsValue(schemeName)) continue;
            schemeMap.put(packageName + schemeName, schemeName);
            packageMap.put(packageName + schemeName, packageName);
        }
        StringBuilder errMsg = new StringBuilder();
        for (Map.Entry entry : schemeMap.entrySet()) {
            String packageName = (String)entry.getKey();
            Boolean ismultipackage = validateEvent.getObj().getDynamicObject("project").getBoolean("ismultipackage");
            if (ismultipackage.booleanValue()) {
                errMsg.append(String.format(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u7684(%1$s)\u6807\u6bb5(%2$s)\u8bc4\u59d4\u5df2\u8bc4\u5206\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u65b9\u6848\u548c\u8bc4\u59d4\u3002", (String)"SrcBidSchemeChgScoreStatusValidator_0", (String)"scm-src-common", (Object[])new Object[0]), packageMap.get(packageName), entry.getValue())).append('\n');
                continue;
            }
            errMsg.append(String.format(ResManager.loadKDString((String)"\u8be5\u5bfb\u6e90\u9879\u76ee\u7684(%1$s)\u8bc4\u59d4\u5df2\u8bc4\u5206\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u65b9\u6848\u548c\u8bc4\u59d4\u3002", (String)"SrcBidSchemeChgScoreStatusValidator_1", (String)"scm-src-common", (Object[])new Object[0]), entry.getValue())).append('\n');
        }
        result.setMessage(errMsg.toString());
        result.setSuccess(false);
        return result;
    }
}

