/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcCreateMaterialEndComp
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.initValueMap(context);
        DynamicObject compObj = SrcBidChangeUtil.createBidChangeComp(context);
        this.setCompValue(context, compObj);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)compObj);
    }

    public void initValueMap(ExtPluginContext context) {
    }

    public void setCompValue(ExtPluginContext context, DynamicObject compObj) {
        compObj.set("scheme", (Object)context.getBillId());
        List purlistIds = (List)context.getParamMap().get("purlist");
        if (null == purlistIds || purlistIds.size() == 0) {
            return;
        }
        boolean isResource = PdsCommonUtils.object2Boolean(context.getParamMap().get("isResource"));
        if (!isResource) {
            String number = PdsCommonUtils.object2String(context.getParamMap().get("number"), (String)"src_materialend_filter");
            isResource = PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueByNumber((String)"pds_extfilter", (String)number, (String)"isResourceAfterPurlistEnd", (Object)false));
        }
        Map countMap = PdsPurlistUtils.getValidPurilstCount((long)context.getProjectId(), (Set)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue(), ProjectStatusEnums.CLOSED.getValue(), ProjectStatusEnums.DECIDED.getValue(), ProjectStatusEnums.SIGNED.getValue()}));
        Map<Object, Object> purlistMap = null;
        if (isResource) {
            QFilter purlistFilter = new QFilter("id", "in", (Object)purlistIds);
            DynamicObjectCollection purlistRows = QueryServiceHelper.query((String)"src_purlistf7", (String)"id,unit.id,qty", (QFilter[])purlistFilter.toArray());
            purlistMap = purlistRows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        }
        if (null == purlistMap) {
            purlistMap = Collections.emptyMap();
        }
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        Iterator iterator = purlistIds.iterator();
        while (iterator.hasNext()) {
            long purlistId = (Long)iterator.next();
            DynamicObject row = rows.addNew();
            row.set("purlist", (Object)purlistId);
            row.set("count", countMap.get(purlistId));
            if (isResource) {
                row.set("issource", (Object)"1");
                row.set("srctype", (Object)context.getProjectObj().getLong("srctype.id"));
                row.set("bidname", (Object)context.getProjectObj().getString("bidname"));
                DynamicObject purlistObj = (DynamicObject)purlistMap.get(purlistId);
                if (null == purlistObj) continue;
                row.set("unit", (Object)purlistObj.getLong("unit.id"));
                row.set("qty", (Object)purlistObj.getBigDecimal("qty"));
                continue;
            }
            row.set("issource", (Object)"0");
        }
    }
}

