/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.feemanage.FeeManageUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcFeeConfigChgService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        long projectId = handleEvent.getObj().getLong("project.id");
        DynamicObject feeCfgObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_paymanage_cfg");
        DynamicObject feeCfgChgObj = this.getCompObj(handleEvent, "src_feeconfigchg");
        this.updateCfgHead(feeCfgObj, feeCfgChgObj);
        this.updateCfgEntry(feeCfgObj, feeCfgChgObj);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)feeCfgObj);
        this.deletePaymentEntry(projectId);
        this.createPaymentEntry(projectId);
        String message = ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d39\u8bbe\u7f6e\u3001\u5220\u9664\u6536\u8d39\u660e\u7ec6\u3001\u91cd\u65b0\u751f\u6210\u6536\u8d39\u660e\u7ec6\u6210\u529f\u3002", (String)"SrcFeeConfigChgService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    public void updateCfgHead(DynamicObject feeCfgObj, DynamicObject feeCfgChgObj) {
        feeCfgObj.set("feeway", (Object)feeCfgChgObj.getLong("feeway.id"));
        feeCfgObj.set("feeitem", (Object)feeCfgChgObj.getLong("feeitem.id"));
        feeCfgObj.set("feeamount", feeCfgChgObj.get("feeamount"));
        feeCfgObj.set("docamount", feeCfgChgObj.get("docamount"));
    }

    public void updateCfgEntry(DynamicObject feeCfgObj, DynamicObject feeCfgChgObj) {
        if (!"C020703".equals(feeCfgChgObj.getString("feeway.number"))) {
            return;
        }
        DynamicObjectCollection cfgRows = feeCfgChgObj.getDynamicObjectCollection("entrypackage");
        Map<Long, DynamicObject> chgRowMap = cfgRows.stream().collect(Collectors.groupingBy(e -> e.getLong("package.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        DynamicObjectCollection rows = feeCfgObj.getDynamicObjectCollection("entrypackage");
        for (DynamicObject row : rows) {
            DynamicObject chgRow = chgRowMap.get(row.getLong("package.id"));
            if (null == chgRow) continue;
            row.set("packfeeitem", (Object)chgRow.getLong("packfeeitem.id"));
            row.set("packfeeamount", chgRow.get("packfeeamount"));
            row.set("packdocamount", chgRow.get("packdocamount"));
        }
    }

    public void deletePaymentEntry(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_payment", (QFilter[])qfilter.toArray());
    }

    public void createPaymentEntry(long projectId) {
        FeeManageUtils.createPaymentEntry((long)projectId);
    }
}

