/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.src.common.contract.SrcContractUtils;

public class SrcMaterialChgValidateService
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = new ValidateResult();
        DynamicObject projectObj = (DynamicObject)validateEvent.getObj().get("project");
        if (null == projectObj) {
            return this.getUnSuccedResult(result, "");
        }
        String message = SrcContractUtils.contractHasPush(projectObj);
        if (null != message) {
            return this.getUnSuccedResult(result, message);
        }
        message = this.allowChangeMaterialInfo(projectObj);
        if (null != message) {
            return this.getUnSuccedResult(result, message);
        }
        result.setSuccess(true);
        return result;
    }

    private String allowChangeMaterialInfo(DynamicObject projectObj) {
        String message = null;
        long flowId = projectObj.getLong("srctype.id");
        QFilter flowFilter = new QFilter("id", "=", (Object)flowId);
        DynamicObject folwObj = QueryServiceHelper.queryOne((String)"pds_flowconfig", (String)"ischgmaterial", (QFilter[])flowFilter.toArray());
        if (folwObj == null) {
            return message;
        }
        boolean ischgmaterial = folwObj.getBoolean("ischgmaterial");
        if (ischgmaterial) {
            return message;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        qfilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if (QueryServiceHelper.exists((String)"src_decision", (QFilter[])qfilter.toArray())) {
            message = ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u5b9a\u6807\u5ba1\u6838\uff0c\u4e14\u8be5\u5bfb\u6e90\u6d41\u7a0b\u5728\u5b9a\u6807\u540e\u4e0d\u5141\u8bb8\u518d\u4fee\u6539\u6807\u7684\u4fe1\u606f\uff0c\u6240\u4ee5\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"SrcMaterialChgValidateService_0", (String)"scm-src-common", (Object[])new Object[0]);
        }
        return message;
    }
}

