/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcMaterialEndApplyAndDemand
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        Set<Long> sourceEntryIds = this.getSourceEntryIds(bidChangeObj);
        if (null == sourceEntryIds || sourceEntryIds.size() == 0) {
            return result;
        }
        this.updateApplyStatus(sourceEntryIds);
        this.updateDemandStatus(sourceEntryIds);
        String message = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"SrcMaterialEndApplyAndDemand_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        return result;
    }

    private void updateApplyStatus(Set<Long> sourceEntryIds) {
        DynamicObject[] rows;
        QFilter qfilter = new QFilter("id", "in", sourceEntryIds);
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_detail", (String)"demandstatus,demandqty,reqqty2,sourceno", (QFilter[])qfilter.toArray())) {
            row.set("sourceno", null);
            row.set("demandstatus", (Object)"A");
            row.set("demandqty", (Object)0);
            row.set("reqqty2", (Object)0);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    private void updateDemandStatus(Set<Long> sourceEntryIds) {
        DynamicObject[] rows;
        QFilter qfilter = new QFilter("srcentryid", "in", sourceEntryIds.stream().map(e -> String.valueOf(e)).collect(Collectors.toSet()));
        for (DynamicObject row : rows = BusinessDataServiceHelper.load((String)"src_demandf7two", (String)"srcbillid,srcentryid,entrystatus11", (QFilter[])qfilter.toArray())) {
            row.set("srcbillid", null);
            row.set("srcentryid", null);
            row.set("entrystatus11", (Object)"D");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    private Set<Long> getSourceEntryIds(DynamicObject bidChangeObj) {
        DynamicObject materialChgObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_materialend");
        if (null == materialChgObj) {
            return null;
        }
        DynamicObjectCollection rows = materialChgObj.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() == 0) {
            return null;
        }
        Set<Long> sourceEntryIds = rows.stream().filter(e -> !e.getBoolean("issource") && e.getLong("supplier.id") == 0L).map(e -> e.getLong("purlist.sourceentryid")).collect(Collectors.toSet());
        return sourceEntryIds;
    }
}

