/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcProjectLockUtil;

public class SrcNegotiateDeadlineChgValidate
implements IDataValidateService {
    private static final long serialVersionUID = 1L;

    public ValidateResult validate(ValidateEvent validateEvent) {
        ValidateResult result = new ValidateResult();
        result.setSuccess(false);
        DynamicObject bidChangeObj = validateEvent.getObj();
        DynamicObject projectObj = bidChangeObj.getDynamicObject("project");
        if (null == projectObj) {
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bfb\u6e90\u9879\u76ee\u201d\u3002", (String)"SrcNegotiateDeadlineChgValidate_0", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        DynamicObject chgDataObj = null;
        Map params = validateEvent.getParams();
        if (null != params) {
            Object timdChgObj = params.get("src_negotiate_timechg");
            if (null != timdChgObj && timdChgObj instanceof DynamicObject) {
                chgDataObj = (DynamicObject)timdChgObj;
            }
        } else {
            chgDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_negotiate_timechg");
        }
        if (null == chgDataObj) {
            result.setMessage(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u201c\u4fdd\u5b58\u201d\u6570\u636e\uff0c\u5982\u672a\u4fdd\u5b58\u6570\u636e\uff0c\u5c06\u65e0\u6cd5\u63d0\u4ea4\u6210\u529f\u3002", (String)"SrcNegotiateDeadlineChgValidate_1", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        DynamicObject negotiateObj = chgDataObj.getDynamicObject("negotiate");
        if (null == negotiateObj) {
            result.setMessage(ResManager.loadKDString((String)"\u8bae\u4ef7\u5355\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcNegotiateDeadlineChgValidate_2", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        if (!BillStatusEnum.AUDIT.getVal().equals(negotiateObj.getString("billstatus"))) {
            result.setMessage(ResManager.loadKDString((String)"\u8be5\u8bae\u4ef7\u5355\u672a\u5ba1\u6838\uff0c\u8bf7\u76f4\u63a5\u4fee\u6539\u6216\u5220\u9664\u5373\u53ef\uff0c\u65e0\u9700\u8fdb\u884c\u53d8\u66f4\u3002", (String)"SrcNegotiateDeadlineChgValidate_3", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        if (negotiateObj.getBoolean("isquotebidopen")) {
            result.setMessage(ResManager.loadKDString((String)"\u8be5\u8bae\u4ef7\u5355\u5df2\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d8\u66f4\u3002", (String)"SrcNegotiateDeadlineChgValidate_4", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        Date newDeadline = chgDataObj.getDate("deadline");
        Date currentTime = TimeServiceHelper.now();
        if (newDeadline == null) {
            result.setMessage(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4(\u53d8\u66f4\u540e)\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SrcNegotiateDeadlineChgValidate_5", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        if (newDeadline.before(currentTime)) {
            result.setMessage(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4(\u53d8\u66f4\u540e)\u4e0d\u5141\u8bb8\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"SrcNegotiateDeadlineChgValidate_6", (String)"scm-src-common", (Object[])new Object[0]));
            return result;
        }
        String lockKey = SrcProjectLockUtil.getBidAutoLockKey(projectObj.getLong("id"));
        if (!SrcProjectLockUtil.tryLockProject(lockKey)) {
            result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u81ea\u52a8\u5f00\u6807\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"SrcNegotiateDeadlineChgValidate_7", (String)"scm-src-common", (Object[])new Object[0]));
            SrcProjectLockUtil.unLockProject(lockKey);
            return result;
        }
        SrcProjectLockUtil.unLockProject(lockKey);
        result.setSuccess(true);
        return result;
    }
}

