/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.util.SrcBidChangeUtil;
import kd.scm.src.common.util.SrcNegotiateChangeUtils;

public class SrcNegotiateEndService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u8bae\u4ef7\u7ec8\u6b62\u5931\u8d25\u3002", (String)"SrcNegotiateEndService_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_negotiate_end");
        long negotiateId = SrmCommonUtil.getPkValue((DynamicObject)compDataObj.getDynamicObject("negotiate"));
        DynamicObject negotiateObj = BusinessDataServiceHelper.loadSingle((Object)negotiateId, (String)"src_negotiatebill");
        this.endNegotiate(negotiateObj);
        SrcBidOpenFacade.setProjectOpenStatus(negotiateObj.getLong("project.id"));
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u8bae\u4ef7\u7ec8\u6b62\u6210\u529f\u3002", (String)"SrcNegotiateEndService_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void endNegotiate(DynamicObject negotiateObj) {
        DynamicObject[] quotebillObjs;
        negotiateObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        negotiateObj.set("bizstatus", (Object)ProcessStatusEnums.CLOSED.getValue());
        negotiateObj.set("isquotebidopen", (Object)"1");
        for (DynamicObject quotebillObj : quotebillObjs = SrcNegotiateChangeUtils.getQuotebillObjs(negotiateObj)) {
            quotebillObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            quotebillObj.set("bizstatus", (Object)ProcessStatusEnums.CLOSED.getValue());
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{negotiateObj});
                SaveServiceHelper.save((DynamicObject[])quotebillObjs);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

