/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcRetenderUnauditService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        DynamicObject[] billObjs;
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject compObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_retender");
        if (null == compObj) {
            return result;
        }
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        Set billIds = rows.stream().map(e -> e.getLong("tenderid.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", billIds);
        for (DynamicObject billObj : billObjs = PdsCommonUtils.loadBillObjsByQFilter((String)"tnd_tenderbill", (QFilter)qfilter)) {
            TndBillAuditContext context = new TndBillAuditContext();
            context.setBillObj(billObj);
            context.setOperationKey("unaudit");
            this.doAuditOperation(context);
        }
        String message = ResManager.loadKDString((String)"\u201c\u9000\u56de\u91cd\u65b0\u6295\u6807\u201d\u53d8\u66f4\u6210\u529f\u3002", (String)"SrcRetenderUnauditService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void doAuditOperation(TndBillAuditContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(ITndBillAuditHandler.class.getSimpleName(), null);
        for (ITndBillAuditHandler handler : handlers) {
            handler.process(context);
        }
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

