/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcRetenderUpdateOpenStatus
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject compObj = this.getCompObj(handleEvent, "src_retender");
        if (!compObj.getBoolean("isreturnbid")) {
            return result;
        }
        long projectId = handleEvent.getObj().getLong("project.id");
        this.updateProjectOpenStatus(handleEvent);
        this.updatePackageOpenStatus(projectId, "src_bidopenpackage");
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        Set<Long> supplierIds = rows.stream().map(e -> e.getLong("tenderid.supplier.id")).collect(Collectors.toSet());
        this.updateTenderSupplierStatus(projectId, supplierIds, "src_bidopensupplier");
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_bidassess_biz", (QFilter[])new QFilter[]{qFilter});
        QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(projectId));
        DeleteServiceHelper.delete((String)"src_decisionsum_sup", (QFilter[])qfilter.toArray());
        return result;
    }

    public void updateProjectOpenStatus(HandleEvent handleEvent) {
        DynamicObject projectObj = this.getProjectObj(handleEvent, "src_project");
        if (null == projectObj) {
            return;
        }
        projectObj.set("openstatus", (Object)BidOpenStatusEnums.NOOPEN.getValue());
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
    }

    public void updatePackageOpenStatus(long projectId, String entityName) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and(new QFilter("istecopen", "!=", (Object)"0").or("isbizopen", "!=", (Object)"0"));
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("isaptopen", (Object)"0");
            row.set("aptopendate", null);
            row.set("aptopenuser", null);
            row.set("isaptassess", null);
            row.set("aptassessdate", null);
            row.set("isaptassess2", null);
            row.set("aptassessdate2", null);
            row.set("istecopen", (Object)"0");
            row.set("tecopendate", null);
            row.set("tecopenuser", null);
            row.set("isbizopen", (Object)"0");
            row.set("bizopendate", null);
            row.set("bizopenuser", null);
            row.set("istecassess", null);
            row.set("tecassessdate", null);
            row.set("isbizassess", null);
            row.set("bizassessdate", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public void updateTenderSupplierStatus(long projectId, Set<Long> supplierIds, String entityName) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("supplier", "in", supplierIds);
        qfilters.and(new QFilter("istecopen", "!=", (Object)"0").or("isbizopen", "!=", (Object)"0").or("isbidpush", "!=", (Object)"0"));
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilters.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("isaptopen", (Object)"0");
            row.set("aptopendate", null);
            row.set("aptopenuser", null);
            row.set("istecopen", (Object)"0");
            row.set("tecopendate", null);
            row.set("tecopenuser", null);
            row.set("isbizopen", (Object)"0");
            row.set("bizopendate", null);
            row.set("bizopenuser", null);
            row.set("isbidpush", (Object)"0");
            row.set("isaptpush", (Object)"0");
            row.set("isaptpush2", (Object)"0");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

