/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcRetenderUpdateScoreStatus
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        HandleResult result = new HandleResult();
        DynamicObject compObj = this.getCompObj(handleEvent, "src_retender");
        if (!compObj.getBoolean("isreturnbid")) {
            return result;
        }
        long projectId = handleEvent.getObj().getLong("project.id");
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        Set<Long> supplierIds = rows.stream().map(e -> e.getLong("tenderid.supplier.id")).collect(Collectors.toSet());
        this.updateScoreTaskStatus(projectId, supplierIds, "src_scoretask");
        this.deleteScoreResult(projectId, supplierIds, "src_bidassess_tec");
        this.deleteScoreResult(projectId, supplierIds, "src_aptituderesultf7");
        this.deleteScoreResult(projectId, supplierIds, "src_aptituderesult2f7");
        return result;
    }

    public void updateScoreTaskStatus(long projectId, Set<Long> supplierIds, String entityName) {
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("supplier", "in", supplierIds);
        qfilters.and("bizstatus", "!=", (Object)"E");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)"bizstatus", (QFilter[])qfilters.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            row.set("bizstatus", (Object)"E");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public void deleteScoreResult(long projectId, Set<Long> supplierIds, String entityName) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and("scoretask.supplier", "in", supplierIds);
        DeleteServiceHelper.delete((String)entityName, (QFilter[])qfilters.toArray());
    }
}

