/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcRetenderUpdateService
implements IDataHandleService {
    private static final long serialVersionUID = 1L;

    public HandleResult handle(HandleEvent handleEvent) {
        DynamicObject[] billObjs;
        HandleResult result = new HandleResult();
        DynamicObject bidChangeObj = handleEvent.getObj();
        DynamicObject compObj = TemplateUtil.getComponentData((String)bidChangeObj.getString("id"), (String)"src_retender");
        if (null == compObj) {
            return result;
        }
        DynamicObjectCollection rows = compObj.getDynamicObjectCollection("entryentity");
        Set billIds = rows.stream().map(e -> e.getLong("tenderid.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", billIds);
        for (DynamicObject billObj : billObjs = PdsCommonUtils.loadBillObjsByQFilter((String)"tnd_tenderbill", (QFilter)qfilter)) {
            billObj.set("istender", compObj.get("istender"));
            billObj.set("isquote", compObj.get("isquote"));
            billObj.set("deadline", compObj.get("newstopbiddate"));
            billObj.set("number", (Object)(billObj.getInt("number") + 1));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])billObjs);
        long projectId = bidChangeObj.getLong("project.id");
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project_base");
        projectObj.set("stopbiddate", compObj.get("newstopbiddate"));
        PdsCommonUtils.saveDynamicObjects((DynamicObject)projectObj);
        String message = ResManager.loadKDString((String)"\u201c\u9000\u56de\u91cd\u65b0\u6295\u6807\u201d\u53d8\u66f4\u6210\u529f\u3002", (String)"SrcRetenderUpdateService_0", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        result.setSuccess(true);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    private void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

