/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSupplierInvalidTenderQuoteBill
implements IDataHandleService {
    private static final long serialVersionUID = 8634249315457733232L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807--\u6295\u6807\u5355\u548c\u62a5\u4ef7\u5355\u5e9f\u6807\u5931\u8d25\u3002", (String)"SrcSupplierInvalidTenderQuoteBill_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        this.invalidTenderQuoteBill(handleEvent.getObj(), "tnd_tenderbill");
        this.invalidTenderQuoteBill(handleEvent.getObj(), "tnd_quotebill");
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807--\u6295\u6807\u5355\u548c\u62a5\u4ef7\u5355\u5e9f\u6807\u6210\u529f\u3002", (String)"SrcSupplierInvalidTenderQuoteBill_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void invalidTenderQuoteBill(DynamicObject bidChangeObj, String entityName) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        Boolean ismultipackage = bidChangeObj.getDynamicObject("project").getBoolean("ismultipackage");
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_supplierinvalid");
        DynamicObjectCollection rows = compDataObj.getDynamicObjectCollection("entryentity");
        List discardList = rows.stream().filter(e -> e.getBoolean("isdiscard")).collect(Collectors.toList());
        Set supplierIds = discardList.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "in", supplierIds);
        DynamicObject[] billObjs = PdsCommonUtils.loadBillObjsByQFilter((String)entityName, (QFilter)qfilter);
        if (null == billObjs || billObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(billObjs.length);
        for (DynamicObject billObj : billObjs) {
            if (!this.isAllPackageInvalid(ismultipackage, billObj, rows)) continue;
            billObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            billObj.set("bizstatus", (Object)ProcessStatusEnums.TERMINATED.getValue());
            billList.add(billObj);
        }
        PdsCommonUtils.saveDynamicObjects(billList);
    }

    protected boolean isAllPackageInvalid(boolean ismultipackage, DynamicObject billObj, DynamicObjectCollection rows) {
        if (!ismultipackage) {
            return true;
        }
        HashSet entryIds = new HashSet();
        HashSet purlistIds = new HashSet();
        HashSet packageIds = new HashSet();
        TndQuoteUtil.getQuoteBillEntryId((DynamicObject)billObj, entryIds, purlistIds, packageIds);
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        if (rows.stream().anyMatch(e -> e.getLong("supplier.id") == supplierId && packageIds.contains(e.getLong("package.id")) && !e.getBoolean("isdiscard"))) {
            return false;
        }
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        qfilter.and("supplier", "=", (Object)supplierId);
        qfilter.and("package", "in", packageIds);
        qfilter.and("isdiscard", "=", (Object)"0");
        return !QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilter.toArray());
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

