/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSupplierInvalidTenderSupplier
implements IDataHandleService {
    private static final long serialVersionUID = 8634249315457733232L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807--\u6309\u6807\u6bb5\u5e9f\u6807\u56de\u6807\u8be6\u60c5\u4f9b\u5e94\u5546\u5931\u8d25\u3002", (String)"SrcSupplierInvalidTenderSupplier_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        this.invalidTenderSupplier(handleEvent.getObj());
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807--\u6309\u6807\u6bb5\u5e9f\u6807\u56de\u6807\u8be6\u60c5\u4f9b\u5e94\u5546\u6210\u529f\u3002", (String)"SrcSupplierInvalidTenderSupplier_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void invalidTenderSupplier(DynamicObject bidChangeObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        Boolean ismultipackage = bidChangeObj.getDynamicObject("project").getBoolean("ismultipackage");
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_supplierinvalid");
        DynamicObjectCollection rows = compDataObj.getDynamicObjectCollection("entryentity");
        List discardList = rows.stream().filter(e -> e.getBoolean("isdiscard")).collect(Collectors.toList());
        Set supplierIds = discardList.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "in", supplierIds);
        DynamicObject[] tenderSupplierObjs = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"suppliertype,supplier,package,isdiscard,reason", (QFilter[])qfilter.toArray());
        if (null == tenderSupplierObjs || tenderSupplierObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> tenderSupplierList = new ArrayList<DynamicObject>(tenderSupplierObjs.length);
        for (DynamicObject row : discardList) {
            List objs = null;
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier"));
            long packageId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package"));
            objs = ismultipackage != false ? Arrays.asList(tenderSupplierObjs).stream().filter(e -> e.getLong("supplier.id") == supplierId && e.getLong("package.id") == packageId).collect(Collectors.toList()) : Arrays.asList(tenderSupplierObjs).stream().filter(e -> e.getLong("supplier.id") == supplierId).collect(Collectors.toList());
            if (null == objs || objs.size() == 0) continue;
            for (DynamicObject obj : objs) {
                obj.set("isdiscard", row.get("isdiscard"));
                obj.set("reason", row.get("reason"));
                tenderSupplierList.add(obj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(tenderSupplierList);
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

