/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.comptpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcPurListCompTplServiceImpl
extends PdsCompTplServiceImpl {
    private List<String> packages = new ArrayList<String>(32);
    private int rowCount;

    public void beforeDoOperation(PdsCompTplContext context) {
        String operateKey;
        this.initParam(context);
        BeforeDoOperationEventArgs beforeDoOperation = context.getBeforeDoOperationEventArgs();
        switch (operateKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                if (this.isCanDoOperation(operateKey)) {
                    this.addPurListCompToTplentry();
                    super.beforeDoOperation(context);
                    break;
                }
                beforeDoOperation.setCancel(true);
                break;
            }
            case "unaudit_cfm": {
                break;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    protected boolean isCanDoOperation(String opKey) {
        DynamicObject obj;
        IFormView iFormView = this.getView();
        if ("submit".equals(opKey)) {
            List compkeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)this.getModel().getDataEntity());
            for (String compkey : compkeyList) {
                String purlistCompId = this.getPageCache().get(compkey);
                this.getPackages(purlistCompId);
            }
            if (this.packages.size() != 0 && this.packages.size() != this.rowCount) {
                iFormView.showErrorNotification(ResManager.loadKDString((String)"\u6807\u6bb5\u5fc5\u987b\u5168\u4e3a\u7a7a\u6216\u5fc5\u586b\u3002", (String)"SrcPurListCompTplServiceImpl_0", (String)"scm-src-common", (Object[])new Object[0]));
                return false;
            }
        }
        if (this.isSrcTypeChange(obj = this.getModel().getDataEntity())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u542f\u52a8\u7684\u5bfb\u6e90\u6d41\u7a0b\u5df2\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u754c\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SrcPurListCompTplServiceImpl_1", (String)"scm-src-common", (Object[])new Object[0]));
            return false;
        }
        if (this.isOrgChanged(obj)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u542f\u52a8\u7684\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u754c\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SrcPurListCompTplServiceImpl_2", (String)"scm-src-common", (Object[])new Object[0]));
            return false;
        }
        if (this.isManageTypeChange(obj)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u542f\u52a8\u7684\u7ba1\u7406\u65b9\u5f0f\u5df2\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u754c\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SrcPurListCompTplServiceImpl_3", (String)"scm-src-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isSrcTypeChange(DynamicObject obj) {
        boolean isExists;
        QFilter filter = new QFilter("id", "=", obj.getPkValue());
        DynamicObject srcType = obj.getDynamicObject("srctype");
        if (null != srcType) {
            filter.and("srctype", "=", srcType.getPkValue());
        }
        return !(isExists = QueryServiceHelper.exists((String)"src_project", (QFilter[])new QFilter[]{filter}));
    }

    private boolean isManageTypeChange(DynamicObject obj) {
        boolean isExists;
        QFilter filter = new QFilter("id", "=", obj.getPkValue());
        String manageType = obj.getString("managetype");
        if (StringUtils.isNotEmpty((String)manageType)) {
            filter.and("managetype", "=", (Object)manageType);
        }
        return !(isExists = QueryServiceHelper.exists((String)"src_project", (QFilter[])new QFilter[]{filter}));
    }

    private boolean isOrgChanged(DynamicObject obj) {
        boolean isExists;
        QFilter filter = new QFilter("id", "=", obj.getPkValue());
        DynamicObject org = obj.getDynamicObject("org");
        if (null != org) {
            filter.and("org", "=", org.getPkValue());
        }
        return !(isExists = QueryServiceHelper.exists((String)"src_project", (QFilter[])new QFilter[]{filter}));
    }

    private void getPackages(String pageId) {
        if (StringUtils.isNotEmpty((String)pageId)) {
            DynamicObjectCollection rows = this.getView().getView(pageId).getModel().getEntryEntity("entryentity");
            rows.forEach(e -> {
                String packageName = e.getString("packagename");
                if (StringUtils.isNotEmpty((String)packageName)) {
                    this.packages.add(packageName);
                }
            });
            this.rowCount += rows.getRowCount();
        }
    }

    private void addPurListCompToTplentry() {
        this.createPurListTplEntryData("isattachpurlist", true);
        this.createPurListTplEntryData("isaddpurlist", true);
    }

    private void createPurListTplEntryData(String pro, boolean isAttach) {
        List<DynamicObject> currCompEntryList = this.getCurrTplCompEntry();
        if (currCompEntryList.size() == 0) {
            return;
        }
        Map<String, DynamicObject> purListTplMap = this.getPurListTplByPro(pro);
        if (purListTplMap.size() == 0) {
            return;
        }
        Map<String, Object> entryGroupKeyMap = this.getTplEntryGroupKey(pro, isAttach);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int i = 0;
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (Map.Entry<String, DynamicObject> tplEntry : purListTplMap.entrySet()) {
            for (DynamicObject compObjEntry : currCompEntryList) {
                DynamicObject component;
                StringBuilder groupKeySb = new StringBuilder();
                groupKeySb.append(tplEntry.getKey());
                ts.set("tmp_template", (Object)tplEntry.getKey(), i);
                String bizObj = compObjEntry.getString("tmp_bizobject");
                if (null != bizObj) {
                    ts.set("tmp_bizobject", (Object)bizObj, i);
                }
                if (null != (component = compObjEntry.getDynamicObject("tmp_component"))) {
                    groupKeySb.append('_').append(component.getPkValue());
                    ts.set("tmp_component", component.getPkValue(), i);
                }
                DynamicObject entryTpl = compObjEntry.getDynamicObject("tmp_template");
                if (isAttach && null != entryTpl) {
                    groupKeySb.append('_').append(entryTpl.getPkValue());
                    ts.set("srctplid", entryTpl.getPkValue(), i);
                }
                if (null != entryGroupKeyMap.get(groupKeySb.toString())) continue;
                ++i;
            }
        }
        if (i > 0) {
            model.batchCreateNewEntryRow("tplentry", ts);
        }
    }

    private List<DynamicObject> getCurrTplCompEntry() {
        ArrayList<DynamicObject> currCompList = new ArrayList<DynamicObject>();
        Object template = this.getModel().getValue("template");
        if (null == template) {
            return currCompList;
        }
        DynamicObject templateDy = (DynamicObject)template;
        DynamicObjectCollection compEntryCols = this.getModel().getEntryEntity("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            DynamicObject tplEntryTemplate = entryCol.getDynamicObject("tmp_template");
            if (null == tplEntryTemplate || !tplEntryTemplate.getPkValue().toString().equals(templateDy.getPkValue().toString())) continue;
            currCompList.add(entryCol);
        }
        return currCompList;
    }

    private Map<String, DynamicObject> getPurListTplByPro(String pro) {
        HashMap<String, DynamicObject> isAttachPurListTplMap = new HashMap<String, DynamicObject>(8);
        DynamicObjectCollection compEntryCols = this.getModel().getEntryEntity("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            DynamicObject tplEntryTemplate = entryCol.getDynamicObject("tmp_template");
            if (null != isAttachPurListTplMap.get(tplEntryTemplate.getPkValue().toString()) || !tplEntryTemplate.getBoolean(pro)) continue;
            isAttachPurListTplMap.put(tplEntryTemplate.getPkValue().toString(), tplEntryTemplate);
        }
        return isAttachPurListTplMap;
    }

    private Map<String, Object> getTplEntryGroupKey(String pro, boolean isAttach) {
        HashMap<String, Object> entryGroupKeyMap = new HashMap<String, Object>();
        DynamicObjectCollection compEntryCols = this.getModel().getEntryEntity("tplentry");
        for (DynamicObject entryCol : compEntryCols) {
            StringBuilder groupKeySb = new StringBuilder();
            DynamicObject tplEntryTemplate = entryCol.getDynamicObject("tmp_template");
            if (!tplEntryTemplate.getBoolean(pro)) continue;
            groupKeySb.append(tplEntryTemplate.getPkValue());
            DynamicObject component = entryCol.getDynamicObject("tmp_component");
            if (null != component) {
                groupKeySb.append('_').append(component.getPkValue());
            }
            if (!isAttach) continue;
            groupKeySb.append('_').append(entryCol.getString("srctplid"));
            entryGroupKeyMap.putIfAbsent(groupKeySb.toString(), groupKeySb.toString());
        }
        return entryGroupKeyMap;
    }
}

