/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsUrlUtil;

public class SrcAllScoredSendMsg
implements IEventServicePlugin {
    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        for (String billId : billIds) {
            DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billId), (String)"src_project");
            String url = PdsUrlUtil.getUrl((String)projectObj.getString("currentnode.bizobject.number"), (Object)billId);
            urlMaps.put(billId, url);
        }
        return urlMaps;
    }

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        String operation = ((EntityEvent)evt).getOperation();
        for (String billId : billIds) {
            QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(billId));
            DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"project,bizrole,bidder", (QFilter[])filter.toArray());
            HashSet<Long> userIds = new HashSet<Long>(16);
            userIds.addAll(Arrays.stream(rows).filter(row -> this.sendRoleList(operation).contains(row.getString("bizrole.number"))).map(row -> row.getLong("bidder.id")).collect(Collectors.toList()));
            userIds.add(rows[0].getLong("project.creator.id"));
            userIdMaps.put(billId, new ArrayList(userIds));
        }
        return userIdMaps;
    }

    private List<String> sendRoleList(String operation) {
        List<String> roleList = new ArrayList<String>(16);
        switch (operation) {
            case "tecallscored": {
                roleList = Arrays.asList("SYS001", "SYS017", "SYS012");
                break;
            }
            case "bizallscored": {
                roleList = Arrays.asList("SYS001", "SYS017", "SYS013");
                break;
            }
            case "aptallscored": {
                roleList = Arrays.asList("SYS001", "SYS019");
                break;
            }
            case "apt2allscored": {
                roleList = Arrays.asList("SYS001", "SYS020");
                break;
            }
        }
        return roleList;
    }
}

