/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.util.PdsUrlUtil;

public class SrcNegoSendMsgToSupplier
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(SrcNegoSendMsgToSupplier.class);

    public String buildUrl(KDBizEvent evt) {
        long projectId;
        StringBuilder url = new StringBuilder();
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        Long pkid = Long.valueOf(businesskey);
        DynamicObject srcNegotiateDyn = QueryServiceHelper.queryOne((String)"src_negotiatebill", (String)"id,project", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        if (srcNegotiateDyn != null && (projectId = srcNegotiateDyn.getLong("project")) != 0L) {
            url.append(PdsUrlUtil.getUrl((String)"tnd_project", (Object)projectId));
        }
        return url.toString();
    }

    public List<Long> calcUserIds(KDBizEvent evt) {
        long projectId;
        ArrayList<Long> userIds = new ArrayList<Long>(1024);
        HashSet<Long> supplierIds = new HashSet<Long>(1024);
        HashSet<Long> bizpartnerIds = new HashSet<Long>(1024);
        HashSet<Long> specialSupUserIds = new HashSet<Long>(1024);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        DynamicObject srcNegotiateDyn = QueryServiceHelper.queryOne((String)"src_negotiatebill", (String)"id,project", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billId))});
        if (srcNegotiateDyn != null && (projectId = srcNegotiateDyn.getLong("project")) != 0L) {
            DynamicObject[] srcBidOpenSupDyns;
            DynamicObjectCollection purListStandDyns = QueryServiceHelper.query((String)"src_purlist_stand", (String)"id,entryentity.entryparentid,entryentity.supplier", (QFilter[])new QFilter[]{new QFilter("entryentity.entryparentid", "=", (Object)billId)});
            if (!purListStandDyns.isEmpty()) {
                for (DynamicObject[] purListStandDyn : purListStandDyns) {
                    long supplier = purListStandDyn.getLong("entryentity.supplier");
                    supplierIds.add(supplier);
                    Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)supplier);
                    bizpartnerIds.add(bizPartnerId);
                }
            }
            userIds.addAll(BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizpartnerIds));
            log.info("administrator user id: " + userIds);
            for (DynamicObject srcBidOpenSupDyn : srcBidOpenSupDyns = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"id,billid,supplier,supplieruser", (QFilter[])new QFilter[]{new QFilter("billid.id", "=", (Object)projectId).and("supplier", "in", supplierIds)})) {
                DynamicObjectCollection supUserDyns = srcBidOpenSupDyn.getDynamicObjectCollection("supplieruser");
                if (supUserDyns == null || supUserDyns.isEmpty()) continue;
                for (DynamicObject supUserDyn : supUserDyns) {
                    long supUserId = supUserDyn.getDynamicObject("fbasedataid").getLong("id");
                    specialSupUserIds.add(supUserId);
                }
            }
            if (!specialSupUserIds.isEmpty()) {
                DynamicObjectCollection specialUserDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("id", "in", specialSupUserIds)});
                for (DynamicObject specialUserDyn : specialUserDyns) {
                    long user = specialUserDyn.getLong("user");
                    userIds.add(user);
                }
            }
        }
        log.info("receive user id: " + userIds);
        return userIds;
    }
}

