/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsUrlUtil;

public class SrcScoreAnalyseSendMeg
implements IEventServicePlugin {
    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        DynamicObjectCollection objs = QueryServiceHelper.query((String)((EntityEvent)evt).getEntityNumber(), (String)"id,project,billid.indextype.number indextype", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds.stream().map(Long::parseLong).collect(Collectors.toList()))});
        Map<Long, List<DynamicObject>> projectMap = objs.stream().collect(Collectors.groupingBy(obj -> obj.getLong("project")));
        HashSet<Long> projectSet = new HashSet<Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : projectMap.entrySet()) {
            if (!projectSet.add(entry.getKey())) continue;
            urlMaps.put(String.valueOf(entry.getValue().get(0).getLong("id")), this.getUrl(entry.getKey(), entry.getValue().get(0).getString("indextype")));
        }
        for (String billId : billIds) {
            if (!Objects.isNull(urlMaps.get(billId))) continue;
            urlMaps.put(billId, null);
        }
        return urlMaps;
    }

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        List billIds = ((EntityEvent)evt).getBusinesskeys();
        DynamicObjectCollection objs = QueryServiceHelper.query((String)((EntityEvent)evt).getEntityNumber(), (String)"id,project,scorer", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds.stream().map(Long::parseLong).collect(Collectors.toList()))});
        Map<Long, List<DynamicObject>> projectMap = objs.stream().collect(Collectors.groupingBy(obj -> obj.getLong("project")));
        HashSet<Long> projectSet = new HashSet<Long>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : projectMap.entrySet()) {
            if (!projectSet.add(entry.getKey())) continue;
            userIdMaps.put(String.valueOf(entry.getValue().get(0).getLong("id")), entry.getValue().stream().map(obj -> obj.getLong("scorer")).distinct().collect(Collectors.toList()));
        }
        for (String billId : billIds) {
            if (!Objects.isNull(userIdMaps.get(billId))) continue;
            userIdMaps.put(billId, Collections.EMPTY_LIST);
        }
        return userIdMaps;
    }

    protected String getUrl(long pkId, String indexType) {
        StringBuilder url = new StringBuilder();
        url.append(PdsUrlUtil.getUrl((String)"src_scoreassist", (Object)pkId));
        String baseType = "";
        switch (indexType) {
            case "SYS004": {
                baseType = "4";
                break;
            }
            case "SYS007": {
                baseType = "7";
                break;
            }
        }
        url.append("&basetype=");
        url.append(baseType);
        return url.toString();
    }
}

