/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.expertchange;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.src.common.expertchange.SrcExpertChangeUtils;

public class SrcExpertChangeAudit
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.updateExpert(context);
    }

    public void updateExpert(ExtPluginContext context) {
        DynamicObject expertChgObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()), (String)"src_myexpertchg");
        long expertId = expertChgObj.getLong("expert.id");
        DynamicObject expertObj = BusinessDataServiceHelper.loadSingle((Object)expertId, (String)"src_myexpert");
        DynamicObjectCollection chgRows = expertChgObj.getDynamicObjectCollection("entrychange");
        if (chgRows.size() == 0) {
            return;
        }
        Set chgFieldSet = chgRows.stream().map(e -> e.getString("fieldid").split("\\|")[0]).collect(Collectors.toSet());
        List properties = SrcExpertChangeUtils.getObjectProperties(expertObj);
        properties = PdsCommonUtils.getIntersectList(properties, chgFieldSet.stream().collect(Collectors.toList()));
        PdsCommonUtils.copyDynamicObjectValue((DynamicObject)expertChgObj, (DynamicObject)expertObj, (List)properties, Collections.emptySet(), (int)-1);
        this.setSpecialValue(expertChgObj, expertObj);
        List entityKeys = PdsMetadataUtil.getEntityKey_namesByControlType((String)"src_expert", (String)"entryap");
        for (String entityKey : entityKeys) {
            String entryEntity = entityKey.split("\\|")[0];
            if (!chgFieldSet.contains(entryEntity)) continue;
            PdsCommonUtils.copyDynamicObjectEntryValue(null, (DynamicObject)expertChgObj, (String)entryEntity, (DynamicObject)expertObj, (String)entryEntity, null, (boolean)true, (boolean)false);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject)expertObj);
        context.setBillObj(expertObj);
    }

    public void setSpecialValue(DynamicObject expertObj, DynamicObject expertChgObj) {
    }
}

