/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.purlist;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCalculateUtils;

public class SrcPurlistEntryEditHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.calcCfmqtyOrderratio(context);
    }

    public void calcCfmqtyOrderratio(ExtPluginContext context) {
        IFormView view = context.getView();
        IDataModel model = view.getModel();
        DynamicObject row = context.getSourceRow();
        int rowIndex = context.getIndex();
        String fieldKey = context.getOperationKey();
        DynamicObject unitObj = row.getDynamicObject("unit");
        BigDecimal qty = row.getBigDecimal("qty");
        BigDecimal cfmqty = row.getBigDecimal("cfmqty");
        BigDecimal orderratio = row.getBigDecimal("orderratio");
        BigDecimal hundred = new BigDecimal("100");
        switch (fieldKey) {
            case "cfmqty": {
                orderratio = cfmqty.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(BigDecimal.ZERO) > 0 ? cfmqty.multiply(hundred).divide(qty, 2, RoundingMode.HALF_DOWN) : BigDecimal.ZERO;
                model.beginInit();
                model.setValue("orderratio", (Object)orderratio, rowIndex);
                model.endInit();
                view.updateView("orderratio", rowIndex);
                break;
            }
            case "orderratio": {
                cfmqty = orderratio.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(BigDecimal.ZERO) > 0 ? PdsCalculateUtils.setScaleByUnit((DynamicObject)unitObj, (BigDecimal)orderratio.multiply(qty).divide(hundred)) : BigDecimal.ZERO;
                model.beginInit();
                model.setValue("cfmqty", (Object)cfmqty, rowIndex);
                model.endInit();
                view.updateView("cfmqty", rowIndex);
                break;
            }
        }
    }
}

