/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.srcoreassist;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.entity.Result;
import kd.scm.pds.common.enums.ResultEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public class SrcScoreBySupLoadDataPlugin
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.clearAllData(context);
        this.createScoreEntry(context);
    }

    protected void clearAllData(ExtPluginContext context) {
        IDataModel model = context.getView().getModel();
        model.deleteEntryData("score_entry");
    }

    private DynamicObjectCollection getScoreData(ExtPluginContext context) {
        IExtPluginHandler queryScoreBySupHandle = (IExtPluginHandler)ExtPluginFactory.getInstance().getExtPluginInstance("ISrcScoreBySupQueryData");
        if (null != queryScoreBySupHandle) {
            Result result = queryScoreBySupHandle.processToReuslt(context);
            if (ResultEnums.SUCCESS.getCode().equals(result.getCode())) {
                return (DynamicObjectCollection)result.getData();
            }
        }
        return null;
    }

    protected void createScoreEntry(ExtPluginContext context) {
        DynamicObjectCollection scoreObjs = this.getScoreData(context);
        if (scoreObjs == null || scoreObjs.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        List properties = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity("score_entry").getDynamicObjectType());
        TableValueSetter ts = new TableValueSetter(new String[0]);
        Set<String> excludedFields = this.getExcludedFields();
        boolean isSumScore = context.getView().getModel().getDataEntity().getBoolean("sumscore");
        int rowIndex = 0;
        long prePackageId = ((DynamicObject)scoreObjs.get(0)).getLong("package");
        for (DynamicObject scoreObj : scoreObjs) {
            long packageId;
            if (isSumScore && prePackageId != (packageId = scoreObj.getLong("package"))) {
                this.setTotalRowValue(ts, rowIndex, prePackageId);
                prePackageId = packageId;
                ++rowIndex;
            }
            this.setRowValue(ts, rowIndex, properties, excludedFields, scoreObj);
            ++rowIndex;
        }
        if (isSumScore) {
            this.setTotalRowValue(ts, rowIndex, prePackageId);
        }
        model.batchCreateNewEntryRow("score_entry", ts);
        EntryGrid grid = (EntryGrid)context.getView().getControl("score_entry");
        grid.selectRows(0);
    }

    protected void setRowValue(TableValueSetter ts, int rowIndex, List<String> properties, Set<String> excludedFields, DynamicObject scoreObj) {
        for (String property : properties) {
            if (excludedFields.contains(property)) continue;
            try {
                if (property.contains("_id")) {
                    ts.set(property, scoreObj.get(property.replace("_id", "")), rowIndex);
                    continue;
                }
                if (scoreObj.get(property) instanceof DynamicObject) {
                    ts.set(property, scoreObj.get(property + "." + "id"), rowIndex);
                    continue;
                }
                ts.set(property, scoreObj.get(property), rowIndex);
            }
            catch (Exception exception) {}
        }
    }

    protected void setTotalRowValue(TableValueSetter ts, int rowIndex, long packageId) {
        ts.set("package_id", (Object)packageId, rowIndex);
        ts.set("indexrule", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1\uff1a", (String)"SrcScoreBySupLoadDataPlugin_0", (String)"scm-src-common", (Object[])new Object[0]), rowIndex);
    }

    protected Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>(8);
        excludedFields.add("id");
        excludedFields.add("seq");
        return excludedFields;
    }
}

