/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.srcoreassist;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public class SrcScoreBySupPropChangeTotalPlugin
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        boolean isSumScore = context.getView().getModel().getDataEntity().getBoolean("sumscore");
        if (context.isVerifyOk() && isSumScore) {
            ChangeData[] changeData;
            PropertyChangedArgs propertyChangeArs = context.getPropertyChangeArgs();
            String propertyName = propertyChangeArs.getProperty().getName();
            for (ChangeData data : changeData = propertyChangeArs.getChangeSet()) {
                this.calcPkgSumScore(context, propertyName, data.getRowIndex());
            }
        }
    }

    public void calcPkgSumScore(ExtPluginContext context, String propertyName, int index) {
        long currPackageId = context.getView().getModel().getEntryRowEntity("score_entry", index).getLong("package.id");
        BigDecimal sumScore = BigDecimal.ZERO;
        for (int i = 0; i < context.getView().getModel().getEntryRowCount("score_entry"); ++i) {
            DynamicObject row = context.getView().getModel().getEntryRowEntity("score_entry", i);
            long packageId = row.getLong("package.id");
            if (packageId != currPackageId) continue;
            if (null != row.get("index")) {
                if (StringUtils.isBlank((Object)row.get(propertyName))) continue;
                sumScore = sumScore.add(row.getBigDecimal(propertyName));
                continue;
            }
            context.getView().getModel().beginInit();
            context.getView().getModel().setValue(propertyName, (Object)sumScore, i);
            context.getView().getModel().endInit();
            context.getView().updateView(propertyName, i);
            break;
        }
    }
}

