/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.srcoreassist;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;

public class SrcScoreInitPkgTotalPlugin
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        boolean isSumScore = context.getView().getModel().getDataEntity().getBoolean("sumscore");
        if (!isSumScore) {
            return;
        }
        if (null == context.getEntryKeys() || context.getEntryKeys().size() == 0) {
            return;
        }
        IDataModel model = context.getView().getModel();
        HashMap<String, BigDecimal> scoreMap = new HashMap<String, BigDecimal>(context.getEntryKeys().size());
        for (int i = 0; i < model.getEntryRowCount("score_entry"); ++i) {
            DynamicObject row = model.getEntryRowEntity("score_entry", i);
            if (null != row.get("index")) {
                this.calcTotalValue(context, scoreMap, row);
                continue;
            }
            this.setTotalValue(context, scoreMap, i);
        }
    }

    public void calcTotalValue(ExtPluginContext context, Map<String, BigDecimal> scoreMap, DynamicObject scoreObj) {
        for (String txtField : context.getEntryKeys()) {
            if (StringUtils.isBlank((Object)scoreObj.get(txtField))) continue;
            if (scoreMap.get(txtField) == null) {
                scoreMap.put(txtField, scoreObj.getBigDecimal(txtField));
                continue;
            }
            scoreMap.put(txtField, scoreMap.get(txtField).add(scoreObj.getBigDecimal(txtField)));
        }
    }

    public void setTotalValue(ExtPluginContext context, Map<String, BigDecimal> scoreMap, int index) {
        for (String txtField : context.getEntryKeys()) {
            if (scoreMap.get(txtField) == null) {
                context.getView().getModel().setValue(txtField, null, index);
                continue;
            }
            context.getView().getModel().setValue(txtField, (Object)scoreMap.get(txtField), index);
            scoreMap.put(txtField, BigDecimal.ZERO);
        }
    }
}

