/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.task.IPdsAutoTaskExecutor;
import kd.scm.pds.common.task.PdsAutoTaskContext;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.negopen.SrcNegOpenFacade;
import kd.scm.src.common.util.SrcProjectLockUtil;

public class SrcNegAutoOpenService
implements IPdsAutoTaskExecutor {
    private static final long serialVersionUID = 1L;

    public synchronized void execute(PdsAutoTaskContext taskContext) {
        DynamicObject[] negObjs;
        BizLog.log((String)"###SrcNegAutoOpenService start execute");
        QFilter qfilters = this.buildQFilter();
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_negotiatebill", (String)"id,project", (QFilter[])qfilters.toArray());
        if (rows == null || rows.size() == 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s\uff1a\u81ea\u52a8\u5f00\u6807\u5931\u8d25\uff0c\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u9879\u76ee\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a%2$s\u3002", (String)"SrcNegAutoOpenService_0", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), qfilters.toString()));
            return;
        }
        StringBuilder message = new StringBuilder();
        Object[] pkIds = new Object[rows.size()];
        Object[] projectIds = new Object[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            pkIds[i] = ((DynamicObject)rows.get(i)).getLong("id");
            projectIds[i] = ((DynamicObject)rows.get(i)).getLong("project");
        }
        Map<String, Object> bidChangeObjMap = this.getBidChangeObjMap(projectIds);
        DynamicObject negObj = BusinessDataServiceHelper.newDynamicObject((String)"src_negotiatebill");
        for (DynamicObject negBillObj : negObjs = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)negObj.getDynamicObjectType())) {
            long projectId = negBillObj.getLong("project.id");
            if (null != bidChangeObjMap.get(String.valueOf(projectId))) {
                BizLog.log((String)("###SrcNegAutoOpenService exist unAudit changeBill:" + projectId));
                continue;
            }
            String result = SrcNegOpenFacade.negAutoOpenVerify(negBillObj);
            if (!"succed".equals(result)) {
                BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bae\u4ef7\u81ea\u52a8\u5f00\u6807\u6821\u9a8c\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a%2$s\u3002", (String)"SrcNegAutoOpenService_1", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), result));
                continue;
            }
            String lockKey = SrcProjectLockUtil.getBidAutoLockKey(projectId);
            if (!SrcProjectLockUtil.tryLockProject(lockKey)) {
                BizLog.log((String)("###SrcNegAutoOpenService getProjectLock fail:" + lockKey));
                continue;
            }
            SrcNegOpenFacade.negOpenHandle(negBillObj);
            SrcBidOpenFacade.setProjectOpenStatus(projectId);
            SrcNegOpenFacade.negDetailsHandle(negBillObj);
            SrcBidOpenFacade.synthCalculate("src_compare", projectId);
            SrcProjectLockUtil.unLockProject(lockKey);
        }
        if (message.length() > 0) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bae\u4ef7\u81ea\u52a8\u5f00\u6807\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a%2$s\u3002", (String)"SrcNegAutoOpenService_2", (String)"scm-src-common", (Object[])new Object[0]), this.getClass(), message.toString()));
        } else {
            BizLog.log((String)"###SrcNegAutoOpenService end.");
        }
    }

    private QFilter buildQFilter() {
        Date currentDate = TimeServiceHelper.now();
        QFilter qfilters = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilters.and("isquotebidopen", "=", (Object)"0");
        qfilters.and("opentype", "=", (Object)"3");
        qfilters.and("deadline", "<=", (Object)currentDate);
        return qfilters;
    }

    private Map<String, Object> getBidChangeObjMap(Object[] pkIds) {
        HashMap<String, Object> bidChangeObjMap = new HashMap<String, Object>(8);
        QFilter bidChangeFilter = new QFilter("project", "in", (Object)pkIds);
        bidChangeFilter.and("template.number", "=", (Object)"SYS064");
        bidChangeFilter.and("billstatus", "=", (Object)"B");
        DynamicObjectCollection bidChangeCols = QueryServiceHelper.query((String)"src_bidchange", (String)"id,project", (QFilter[])bidChangeFilter.toArray());
        for (DynamicObject bidChange : bidChangeCols) {
            bidChangeObjMap.put(String.valueOf(bidChange.getLong("project")), bidChange);
        }
        return bidChangeObjMap;
    }
}

